'\"
'\" Copyright 1993-1996 by AT&T Bell Laboratories.
'\" 
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Bitmap command created by George Howlett.
'\"
.so man.macros
.HS bitmap BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
bitmap \- Define a new bitmap from a Tcl script
.SH SYNOPSIS
\fBbitmap define \fIbitmapName data\fR ?\fIoption value\fR...?
.sp
\fBbitmap compose \fIbitmapName text\fR ?\fIoption value\fR...?
.sp
\fBbitmap exists \fIbitmapName\fR
.sp
\fBbitmap source \fIbitmapName\fR
.sp
\fBbitmap data \fIbitmapName\fR
.sp
\fBbitmap height \fIbitmapName\fR
.sp
\fBbitmap width \fIbitmapName\fR
.BE
.SH DESCRIPTION
The \fBbitmap\fR command lets you define new bitmaps.  
The bitmap can be given as a list of data or a text string
which is converted into a bitmap.  You can arbitrarily scale
or rotate the bitmap too.
.SH INTRODUCTION
Bitmaps are commonly used within Tk.  In labels and buttons, you can
use them as images instead of text strings.  In the canvas and text
widgets, they are used for stippling.  But if you want to define your
own bitmap (i.e. one other than the handful of built-in bitmaps), you
must create an ASCII file and let Tk read the bitmap in.  This makes
it cumbersome to manage bitmaps, especially when you are distributing
the program as a \fBwish\fR script, since each bitmap must be its own
file.  It would be much easier to be able define new bitmaps from Tcl.
.PP
The \fBbitmap\fR command lets you do just that.  You can define
new bitmaps right from a Tcl script.  You can specify the bitmap as a
list of data, similar to the X11 bitmap format.  You can also
\fBbitmap\fR to generate a bitmap from a text string and rotate or
scale it as you wish.  For example, you could use this to create 
buttons with the text label rotated ninty degrees.
.SH EXAMPLE
You can define a new bitmap with the \fBdefine\fR operation.  Here is
an example of it. We are creating a new stipple by defining a new
bitmap called "light_gray".
.nf

\fC	bitmap define light_gray { { 4 2 } { 0x08, 0x02 } }\fR

.fi
Tk will now recognize "light_gray" as a bitmap which can be used
with widgets.
.nf

\fC	.barchart element configure elem1 -stipple light_gray\fR

.fi
The last argument is the data which defines the bitmap. It is itself a
list of two lists.  The first list contains the height and width of
the bitmap.  The second list is the source data.  Each element is an
hexadecimal number specifying which pixels are foreground and which
are background of the bitmap.  The format of the source data is
exactly that of the ASCII X11 bitmap format.  The \fBdefine\fR
operation is quite lienient about the format of the source data.  The
data elements may or may not be separated by commas.  They may or may
not be prefixed by "0x".  All of the following definitions are
equivalent.
.nf

\fC	bitmap define light_gray { { 4 2 } { 0x08, 0x02 } }\fR
\fC	bitmap define light_gray { { 4 2 } { 0x08 0x02 } }\fR
\fC	bitmap define light_gray { { 4 2 } { 8 2 } }\fR

.fi
You can scale or rotate the bitmap as you create it, by using the
"-scale" or "-rotate" options.
.nf

\fC	bitmap define light_gray { { 4 2 } { 0x08, 0x02 } } \\
		-scale 2.0 -rotate 90.0\fR

.fi
You can also generate a bitmaps from text using the \fBcompose\fR
operation.  This makes it easy to create rotated buttons or labels.
The text string you designate can also have embedded newlines.
.nf

\fC	bitmap compose rot_text "This is rotated\\ntext" \\
		-rotate 90.0 -font fixed \fR

.fi
There are a number of ways to query bitmaps.
.nf

\fC	bitmap exists rot_text\fR
\fC	bitmap width rot_text\fR
\fC	bitmap height rot_text\fR
\fC	bitmap data rot_text\fR
\fC	bitmap source rot_text\fR

.fi
The \fBexists\fR operation indicates if a bitmap by that name is
defined.  You can query the dimensions of the bitmap using the
\fBwidth\fR and \fBheight\fR operations. The \fBdata\fR operation
returns the list of the data used to create the bitmap.  And you can
query the data of any bitmap, not just those created by
\fBbitmap\fR.  This means you can \fBsend\fR bitmaps from one
application to another.
.nf

\fC	set data [bitmap data @/usr/X11R6/include/X11/bitmaps/ghost.xbm]\fR
\fC	send {wish #2} bitmap define ghost $data\fR

.fi
.DE
.SH OPERATIONS
The following operations are available for \fBbitmap\fR:
.TP
\fBbitmap compose \fIbitmapName text \fR?\fIoptions\fR?
Creates a bitmap \fIbitmapName\fR from the text string \fItext\fR.
A bitmap \fIbitmapName\fR can not already exist.  
The following options are available.
.RS
.TP
\fB\-font \fIfontName\fR 
Specifies a font to use when drawing text into the bitmap.
If this option isn't specified then \fIfontName\fR defaults to 
\fC*-Helvetica-Bold-R-Normal-*-140-*\fR.
.TP
\fB\-rotate \fItheta\fR
Specifies the angle of rotation of the text in the bitmap.
\fITheta\fR is a real number representing the angle in degrees.
It defaults to \fC0.0\fR degrees.
.TP
\fB\-scale \fIvalue\fR
Specifies the scale of the bitmap.
\fIValue\fR is a real number representing the scale.  A scale
of 1.0 indicates no scaling is necessary, while 2.0 would
double the size of the bitmap.  There is no way to specify
differents scales for the width and height of the bitmap.
The default scale is \fC1.0\fR.
.RE
.TP
\fBbitmap data \fIbitmapName\fR 
Returns a list of both the
dimensions of the bitmap \fIbitmapName\fR and its source data.
.TP
\fBbitmap define \fIbitmapName data\fR \fR?\fIoptions\fR?
Associates \fIbitmapName\fR with in-memory bitmap data so that
\fIbitmapName\fR can be used in later calls to \fBTk_GetBitmap\fR.
The \fIbitmapName\fR argument is the name of the bitmap; it must not
previously have been defined in either a call to Tk_DefineBitmap or
\fBbitmap\fR.  The argument \fIdata\fP describes the bitmap to
be created.  It is a list of two elements, the dimensions and source
data.  The dimensions are a list of two numbers which are the width
and height of the bitmap.  The source data is a list of hexadecimal
values in a format similar to the X11 or X10 bitmap format.  The
values may be optionally separated by commas and do not need to be
prefixed with "0x".  The following options are available.
.RS
.TP
\fB\-rotate \fItheta\fR
Specifies how many degrees to rotate the bitmap.
\fITheta\fR is a real number representing the angle.
The default is \fC0.0\fR degrees.
.TP
\fB\-scale \fIvalue\fR
Specifies how to scale the bitmap.
\fIValue\fR is a real number representing the scale.  A scale
of 1.0 indicates no scaling is necessary, while 2.0 would
double the size of the bitmap.  There is no way to specify
differents scales for the width and height of the bitmap.
The default scale is \fC1.0\fR.
.RE
.TP
\fBbitmap exists \fIbitmapName\fR 
Returns \fC1\fR if a bitmap \fIbitmapName\fR exists, otherwise \fC0\fR. 
.TP
\fBbitmap height \fIbitmapName\fR 
Returns the height in pixels of the bitmap \fIbitmapName\fR.
.TP
\fBbitmap source \fIbitmapName\fR 
Returns the source data of the bitmap \fIbitmapName\fR. The source data is a 
list of the hexadecimal values.  
.TP
\fBbitmap width \fIbitmapName\fR 
Returns the width in pixels of the bitmap \fIbitmapName\fR.
.SH LIMITATIONS
Tk currently offers no way of destroying bitmaps.  Once a bitmap is
created, it exists until the application terminates.
.SH KEYWORDS
bitmap
