'\"
'\" Copyright 1993-1996 by AT&T Bell Laboratories.
'\"
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Busy command created by George Howlett.
'\"
.so man.macros
.HS busy BLT
.BS 
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
busy \- Make Tk widgets busy, temporarily blocking user interactions.
.SH SYNOPSIS
\fBbusy hold \fIwindow\fR ?\fIoption value\fR?...
.sp
\fBbusy release \fIwindow\fR ?\fIwindow\fR?...
.sp
\fBbusy configure \fIwindow\fR ?\fIoption value\fR?...
.sp
\fBbusy forget \fIwindow\fR ?\fIwindow\fR?...
.sp
\fBbusy isbusy \fR?\fIpattern\fR?
.sp
\fBbusy status \fIwindow\fR 
.sp
\fBbusy windows \fR?\fIpattern\fR?
.BE
.SH DESCRIPTION
.PP
The \fBbusy\fR command provides a simple means to block
keyboard, button, and pointer events from Tk widgets, while overriding
the widget's cursor with a configurable busy cursor.
.SH INTRODUCTION
.PP
There are many times in applications where you want to temporarily
restrict what actions the user can take.  For example, an application
could have a "run" button that when pressed causes some processing to
occur.  But while the application is busy processing, you probably don't
want the the user to be able to click the "run" button again.  You
may also want restrict the user from other tasks such as clicking the
"print" button.
.PP
The \fBbusy\fR command lets you make Tk widgets busy. This means
that user interactions such as button clicks, moving the mouse, typing
at the keyboard, etc. are ignored by the widget.  You can also set a
special cursor (like a watch) which overrides the widget's normal
cursor, providing feedback that the application (widget) is
temporarily busy.
.PP
When a widget is made busy, all of the widgets in its window
hierarchy also become busy.  It's easy then to make an entire panel of
widgets busy by simply making the uppermost widget (such as ".") busy.
This is far easier and much more efficient than recursively traversing
the widget hierarchy, disabling each widget and re-configuring its
cursor.
.PP
The busy command can also be used in many cases instead of Tk's \fBgrab\fR
command.  Unlike \fBgrab\fR which directs all user interaction to one
widget, the busy command allows more than one widget to be active (for
example, a "cancel" dialog and a "help" button) while the other
widgets are busy.
.SH EXAMPLE
You can make a set of widgets busy by simply making the uppermost widget
in the hierarchy busy using the \fBhold\fR operation.  
.nf

\fC	frame .top
	button .top.button; canvas .top.canvas
	pack .top.button .top.canvas
	pack .top
	  . . .
	busy hold .top
	update\fR

.fi
All the widgets within \fC.top\fR (including \fC.top\fR) are now busy.  
The \fBupdate\fR command insures that \fBbusy\fR command has a 
chance to effect.
.PP
When the application is no longer busy, you can allow user interaction again 
by the \fBrelease\fR operation.
.nf

\fC	busy release .top \fR

.fi
You can change the busy cursor using the \fBconfigure\fR operation.
.nf

\fC	busy configure .top -cursor "watch"\fR

.fi
Finally, when you no longer need to make the widget busy anymore, 
invoke the \fBforget\fR operation to free any resources allocated.
.nf

\fC	busy forget .top \fR

.fi
Destroying the widget also cleans up any resources allocated
by the busy command.
.PP
.SH OPERATIONS
The following operations are available for the \fBbusy\fR command:
.TP
\fBbusy hold \fIwindow\fR ?\fIoption value\fR?...
Makes the widget \fIwindow\fR (and its descendants in the Tk window hierarchy)
busy.  \fIWindow\fR must be a valid path name of a Tk widget.  At the next
idle time, this widget will be blocked from user interactions. All device 
events for the widget window and it descendants will be ignored.
Typically \fBupdate\fR should be called immediately afterward to insure 
that the \fBhold\fR operation is in effect \fIbefore\fR the application 
starts its processing. The following configuration 
options are valid:
.RS
.TP
\fB\-cursor \fIcursorName\fR
Specifies the cursor to be displayed when the widget is made busy.
\fICursorName\fR can be in any form accepted by \fBTk_GetCursor\fR.
The default cursor is \fBwatch\fR.
.RE
.TP
\fBbusy configure \fIwindow\fR ?\fIoption value\fR?...
Queries or modifies the \fBbusy\fR command configuration options for 
\fIwindow\fR. \fIWindow\fR must be the path name of a widget previously
made busy by the \fBhold\fR operation.  If no options are
specified, a list describing all of the available options for
\fIwindow\fR (see \fBTk_ConfigureInfo\fR for information on the format
of this list) is returned.  If \fIoption\fR is specified with no
\fIvalue\fR, then the command returns a list describing the one named
option (this list will be identical to the corresponding sublist of
the value returned if no \fIoption\fR is specified).  If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given widget option(s) to have the given value(s); in this case the
command returns the empty string.  \fIOption\fR may have any of the
values accepted by the \fBhold\fR operation.  
.sp
Please note that the
option database is referenced through \fIwindow\fR.  For example, if 
the widget \fC.frame\fR is to be made busy, the busy 
cursor can be specified for it by either \fBoption\fR command:
.nf

	\fCoption add *frame.busyCursor gumby\fR
	\fCoption add *Frame.BusyCursor gumby\fR

.fi
.TP
\fBbusy forget \fIwindow\fR ?\fIwindow\fR?...
Releases resources allocated by the busy command for \fIwindow\fR,
including the InputOnly window.  User events will again be received again 
by \fIwindow\fR.  Busy resources are also released when \fIwindow\fR
is destroyed. \fIWindow\fR must be the name of a widget specified 
in the \fBhold\fR operation, otherwise an error is reported.
.TP
\fBbusy isbusy \fR?\fIpattern\fR?
Returns the pathnames of all widget windows which are currently busy.
If a \fIpattern\fR is given, the path names of busy widgets 
matching \fIpattern\fR are returned.
.TP
\fBbusy release \fIwindow\fR ?\fIwindow\fR?...
Restores user interactions to all of the widget \fIwindow\fR again. 
This differs from the \fBforget\fR operation in that the InputOnly window 
is not destroyed, but simply unmapped.  
\fIWindow\fR must be the name of a widget specified 
in a \fBhold\fR operation, otherwise an error is reported.
.TP
\fBbusy status \fIwindow\fR
Returns the status of a widget \fIwindow\fR previously made busy.
An error is reported if \fIwindow\fR was never made busy, or
the \fBforget\fR operation was invoked (i.e. does not currently have a
InputOnly window associated with it).  If \fIwindow\fR is presently can
not receive user interaction, \fC1\fR is returned, otherwise \fC0\fR.
.TP
\fBbusy windows \fR?\fIpattern\fR?
Returns the pathnames of all widget windows which have previously
been made busy (i.e. an InputOnly is allocated and associated with 
the widget).  If a \fIpattern\fR is given, the path names of busy 
widgets matching \fIpattern\fR are returned.
.sp 1
.SH BINDINGS
The blocking feature is implemented by creating and mapping a
transparent InputOnly class window which completely covers the
widget.  When the InputOnly window is mapped, it intercepts all
events which could be sent to the widget and its hierarchy.  
Like Tk widgets, the InputOnly windows have names in the
Tk window hierarchy.  This means that you can use the \fBbind\fR 
command, to handle events in the InputOnly window.
.nf

\fC	busy hold .frame.canvas
	bind .frame.canvas_Busy <Enter> { ... } \fR

.fi
.PP
Typically, the InputOnly window is a sibling of the widget's window.
The name of the InputOnly window will be "\fIwidget\fC_Busy\fR" where 
\fIwidget\fR is the name of the widget made busy.  In the above example,
the pathname of the InputOnly window is "\fC.frame.canvas_Busy\fR"
The exception is when the widget is a toplevel window (such as ".").
Then the InputOnly window is a child of the widget's window and the name of
the widget will be "\fIwidget\fC._Busy\fR" where \fIwidget\fR is the name 
of the widget made busy.  In the following example,
.nf

\fC	busy hold .
	bind ._Busy <Enter> { ... } \fR

.fi
the pathname of the InputOnly window is "\fC._Busy\fR" 
.SH ENTER/LEAVE EVENTS
Mapping and unmapping the InputOnly window generates Enter/Leave
events for all widget (windows) that it covers.  Please note this when
you are tracking Enter/Leave events in widgets.
.SH KEYBOARD EVENTS
When a widget is made busy, the widget is prevented from gaining the
keyboard focus by the InputOnly window. But Tk widgets can still get
keyboard events if the keyboard focus is already set. Care must be
taken to move focus to another window.
.nf

\fC	busy hold .frame
	label .dummy
	focus .dummy
	update\fR

.fi
The above example moves the focus from .frame immediately after
invoking the \fBhold\fR so that no keyboard events will be relayed to
windows under the hierarchy of \fC.frame\fR.
.SH KEYWORDS
busy, keyboard events, pointer events, window, cursor


