'\"
'\" Copyright 1993-1996 by AT&T Bell Laboratories.
'\"
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Bgexec command created by George Howlett.
'\"
.so man.macros
.HS bgexec BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
bgexec \- Run Unix commands in the background while handling
Tk events.
.SH SYNOPSIS
\fBbgexec \fIvarName\fR ?\fIoptions\fR? \fIcommand\fR ?\fIarg\fR ...?
.BE
.SH DESCRIPTION
.PP
The \fBbgexec\fR command executes Unix commands in the
background as subprocesses, allowing Tk to handle events.  A
global Tcl variable \fIvarName\fR is set when the subprocesses have
completed.
.SH INTRODUCTION
Tcl's \fBexec\fR command is very useful for gathering information from
the system.  It runs a Unix command and returns the output of the
command as its result.  This works well for Tcl-only applications. But
in Tk applications, a problem occurs when the Unix command takes time
to process.  For example, let's say we want the get the disk usage of
a directory.  We'll use the Unix command \fCdu\fR to get the summary.
.nf

\fC	set out [exec du -s $dir]
	puts "Disk usage for $dir is $out"\fR

.fi
The problem is that while \fCdu\fR is running, Tk is not handling X
events.  Scrollbars won't respond.  None of the widgets will be
redrawn properly.  The \fBsend\fR command won't work.  And the worst
part is that the application appears hung up or dead.
.PP
The \fBbgexec\fR command performs the same functions as
\fBexec\fR, but also allows Tk to handle events.  You can execute a
long-running Unix command and still have the Tk widgets work normally.
When the command finishes, its output and the exit status are stored
in Tcl variables.  This makes it easy to monitor and save the output
of a command.
.SH EXAMPLE
This is the disk usage example again, this time using \fBbgexec\fR.  
The Unix command syntax is exactly the same as \fBexec\fR.
.nf

\fC	global status out
	bgexec status -output out du -s $dir
	puts "Disk usage for $dir is $out"\fR

.fi
The example's using two global variables, \fCstatus\fR and \fCout\fR,
which will be set by \fBbgexec\fR when the \fCdu\fR command has
completed. \fCStatus\fR will contain the command's exit status.
\fCOut\fR, specified by the \fB\-output\fR option, will store the output of
the command.
.PP
You can also terminate the command by setting the variable \fCstatus\fR.
If \fCstatus\fR is set before \fCdu\fR has completed, the process
is killed by sending a configurable Unix signal (by default it's
SIGHUP).  It makes no difference what \fCstatus\fR is set to.
.nf

\fC	set status {}\fR

.fi
You can set other \fBbgexec\fR options to collect different types of 
information.
.nf

\fC	global status out errs
	bgexec status -output out -error errs du -s $dir\fR

.fi
The \fB\-error\fR option is similar to \fB\-output\fR.  It sets a global
variable when the command completes.  The variable will contain
any data written to stderr by the command.
.PP
Note that the \fB\-output\fR and \fB\-error\fR variables get set only after the
command finally completes.  If the command takes a long time, you may
want to get its partial output.  You can gather data as it becomes
available using the \fB\-update\fR option.  It sets a global variable
as new data is output.  
.nf

\fC	global status info
	trace variable info w TraceInfo
	bgexec status -update info du -s $dir\fR

.fi
When new data becomes available, the variable \fCinfo\fR gets updated
with the information.  The example also uses a Tcl variable trace to
handle the updates when they occur.  Whenever \fCinfo\fR is updated,
the proc \fCTraceInfo\fR will be called.
.PP
Like \fBexec\fR, \fBbgexec\fR returns an error if the exit code of
the Unix command is not zero.  If you think you may get a non-zero
exit code, you might want to invoke \fBbgexec\fR from within a
\fBcatch\fR.
.nf

\fC	catch { bgexec status -output out du -s $dir }\fR

.fi
By default, \fBbgexec\fR will wait for the command to finish.
But you can detach the command by adding an ampersand (&) to the
end of the command line.
.nf

\fC	global status out
	bgexec status -output out du -s $dir &\fR

.fi
\fBbgexec\fR will return immediately and its result will be a list
of the spawned process ids.  You can still use \fBtkwait\fR if you
need to wait for the command to finish.
.nf

\fC	global status out
	bgexec status -output out du -s $dir &
		...
	tkwait variable status\fR
.fi
.SH SYNTAX
The \fBbgexec\fR command takes the following form:
.sp
\fB	bgexec \fIvarName\fR ?\fIoptions\fR?... \fIcommand\fR ?\fIargs\fR ...?
.sp
\fIVarName\fR is the name of a global variable which is set when the
designated Unix command has finished executing.  The exit status of
the command will be stored in \fIvarName\fR.  The exit status is a
list of a status token, the process id of the command, the exit code,
and a completion message.  You can also prematurely terminate the
command by setting \fIvarName\fR while the command is running.  The
command is sent a signal to terminate it (by default a SIGHUP; see the
\fB\-killsignal\fR option).
.PP
\fICommand\fR is the name of the Unix command to be executed and
\fIargs\fR are any extra arguments for \fIcommand\fR.  The syntax
matches that of the \fBexec\fR command. \fICommand\fR and \fIargs\fR
may be in any form accepted by \fBexec\fR. See the \fBexec\fR manual
for further information.  If the last argument is an ampersand (&),
the command will be run detached, and \fBbgexec\fR will return
immediately.  \fIVarName\fR will still be set with the status when
\fIcommand\fR completes.
.SH OPTIONS
\fIOptions\fR are pairs of option-value words.   This first word is 
option name, always beginning with a dash (\-).  The second word is the
option value.  Option pairs are terminated either by the Unix command
name, or double dashes (\-\-).  The following options are available:
.TP 
\fB\-error \fIvarName\fR 
.br
Specifies that a global variable \fIvarName\fR is to be set with the
contents of stderr after the command has completed. 
.TP 
\fB\-keepnewline \fIboolean\fR
Specifies that a trailing newline should be retained in the 
output. If \fIboolean\fR is true, the trailing newline is truncated
from the output of the \fB\-update\fR and \fB\-output\fR variables.  
The default value is \fCtrue\fR.
.TP 
\fB\-killsignal \fIsignal\fR
Specifies the signal to be sent to the Unix command when 
terminating. \fISignal\fR can either be a number (typically 1-32) or
a mnemonic (e.g. SIGINT). If \fIsignal\fR is the empty string, 
then no signal is sent.  The default signal is \fC1\fR (SIGHUP).
.TP 
\fB\-output \fIvarName\fR
.br
Specifies that a global variable \fIvarName\fR is to be set with the
output of the command, after the commmand has completed.  If this option 
is not set, no output will be accumulated.
.TP 
\fB\-update \fIvarName\fR
Specifies that a global variable \fIvarName\fR is to be updated when
data is written to stdout of the command.  Unlike the \fB\-output\fR
option, \fIvarName\fR is updated as soon as new data becomes available.
.TP 
\fB\-\|\-\fR
This marks the end of the options.  The following argument will
be considered the name of a Unix command even if it starts with 
a dash (\fB\-\fR).
.SH PREEMPTION
Because Tk events are handled while a Unix command is running, it's
possible for an application to preempt itself by further
user-interactions.  Let's say your application has a button that when
pressed runs the disk usage example.  The user may press the button
again, while the \fCdu\fR command is already running.  The second
\fBbgexec\fR command will preempt the first.  This means that the
first command cannot finish until the second command has completed.
.PP
Care must be taken to prevent an application from preempting itself,
by blocking further user-interactions (such as button clicks).  The
\fBbusy\fR command is very useful in these situations, temporarily
preventing user interaction. See the \fBbusy\fR manual for
details.
.SH DIFFERENCES WITH FILEEVENT
Some of the functionality of \fBbgexec\fR is now be provided in Tk 4.0
with the \fBfileevent\fR command.  The steps for running a command in
the background are:
.PP
Execute the Unix command with the \fBopen\fR command using the
"|" and save the file handle.
.nf

\fC	global fileId 
	set fileId [open "|du -s $dir" r]\fR

.fi
Then register a Tcl code snippet with \fBfileevent\fR to be run
whenever output is available on the file handle.  The code snippet
will read from the file handle and save the output.
.nf

\fC	fileevent fileId readable { 
	    if { [gets $fileId line] < 0 } {
		close $fileId
		set output $temp
		unset fileId temp
	    } else {
		append temp $line
	    }
	}\fR

.fi
This works with the above example, but there are some differences.
.PP
The biggest advantage of using \fBbgexec\fR is that it requires no
additional Tcl code to run a command.  It's simpler and there's less 
chance of errors being introduced.
.PP
\fBBgexec\fR also handles things which \fBfileevent\fR can not.  For
example, you can't get back the exit status of the command.  In the
code above, we're assuming that the command has completed once stdout
is closed.  The problem is that some commands, like \fCcompress\fR,
reopen stdout, fooling \fBfileevent\fR.  We're also assuming that the
Unix command will write its output line-by-line.  Running another
command, your application may block in the \fBgets\fR command, reading
a partial line.  Conversely, \fBbgexec\fR handles non-blocking I/O
tranparently for you.  Finally, since data collection is handled in C
code, \fBbgexec\fR is faster, getting you back to the event loop more
quickly.
.SH SEE ALSO
busy, exec, tkwait
.SH KEYWORDS
exec, background, busy
