'\"
'\" Copyright 1995 Sven Delmas
'\" All rights reserved.
'\" See the file COPYRIGHT for the copyright notes.
'\"
'\" $Header: tkemacs.n[15.0] Wed Aug  2 11:43:18 1995 sven@(none) frozen $
'\" 
'\" The manual page is based upon the manual page style from:
'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES. This file is
'\" part of the Tk distribution and is included in the file COPYRIGHT.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.HS tkemacs cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tkemacs \- Emacs with menubars, scrollbars and more
.SH SYNOPSIS
\fBtkemacs\fR ?\fIoptions\fR?\fR ?\fIfilenames\fR?
.SH OPTIONS
.IP "\fB\-display \fIdisplay\fR" 15
Display (and screen) on which to display window.
.IP "\fB\-geometry \fIgeometry\fR" 15
Initial geometry to be used for window.
.IP "\fB\-function \fIlisp-function\fR" 15
Runs lisp function in emacs. The function must be a valid emacs
function call (enclosed in '()').
.IP "\fB\-load \fIfile\fR" 15
Loads the lisp code in the file \fIfile\fR.
.IP "\fB\-client\fR" 15
Starts tkemacs as client. This means that tkemacs tries
to use an existing tkemacs for editing.
.IP "\fB\-cbColorFile \fIfilename\fR" 15
This option specifies a file containing a list of all known
colors. This file is automatically created when CIMBuilder is
installed, so please set this variable to the location of the
\fBColors\fR file of the installed CIMBuilder (usually in the
directory ./lib/cb inside the CIMBuilder distribution).
.IP "\fB\-cbFontFile \fIfilename\fR" 15
This option specifies a file containing a list of all known
fonts. This file is automatically created when CIMBuilder is
installed, so please set this variable to the location of the
\fBFonts\fR file of the installed CIMBuilder (usually in the 
directory ./lib/cb inside the CIMBuilder distribution).
.IP "\fB\-cbLoadPath \fIpathname\fR" 15
This option specifies a list of pathnames (separated by ":") where
the tkemacs Tcl source files can be found. In order to find the
Tcl source files, they must be stored in one of these
directories. 
.IP "\fBfilenames\fR" 15
The given filenames are loaded into the emacs at startup.
.BE

.SH DESCRIPTION
.PP
\fBTkemacs\fR is a simple program that provides access to emacs
(emacs 18.57 or a later version and Lucid-emacs 19.6 or a later
version) under a Tcl/Tk environment. It is based upon the
\fBTkSteal\fR extension which adds the command \fBxaccess\fR.
You can define pull-down menus which directly call emacs lisp
functions. This gives you full access to emacs with
additional functionality provided by Tcl/Tk. \fBTkemacs\fR
is just a little demo program for the \fBTkSteal\fR
extension, so don't expect too much. Feel free to adapt the
program for your local needs. If you make substantial
(interesting :-) changes, please let me know, so I can
include them into future releases.

To add a file to an \fBtkemacs\fR already running, you can call
\fBtkemacsc\fR. This calls \fBtkemacs\fR as a client. That means
that the files are loaded in the \fBtkemacs\fR already running.

.SH MENU-STRUCTURE
.PP
The menu structure of \fBtkemacs\fR can be adapted by you.
Select the menu item \fBMenubar menus\fR in the pull-down
menu \fBConfigure\fR. You can select which menus you want to
modify. This is done with a dialog box which allows you to
manipulate the menubuttons and menus that are used by
\fBtkemacs\fR. For users who are not familiar with the
programming of Tcl/Tk, I would recommend to take a short
look at the documentation of Tcl/Tk (especially concerning
the menubuttons and the menus). If you only want to send
lisp code, this might not be necessary.
.PP
There are 15 menubuttons that can be configured. You see all
the available menubuttons in the list up right. Select one
menubutton from the list to display its current configuration
in the left area of the dialog box. If a menubutton has a label,
it will be displayed; otherwise it will be hidden. The order of
the menubuttons is not changeable. The menubutton has an option
(named menu) that links a menu to a menubutton. By changing
this option, you can change the order of the menus. Some
of the resources can be changed with additional dialog boxes.
To call such a dialog (e.g. a color selection box), double
click the right mouse button into the text field you want to
change. All changes can be applied to the menubutton by
pressing the button \fBModify\fR. If you change the
visibility of a button (by adding/deleting a label), this
change will affect the menubutton at the next startup of
tkemacs.
.PP
The menus can be changed by selecting the menu in the list
showing the names of all menus that are currently defined. You
can change the parameters for the menu, or the items that the
menu contains. In the first case the handling is exactly like
the handling of menubuttons. The only difference is that you
can add/delete menus. If you select the button \fBModify
Menu\fR, the dialog window changes and you see a list of the
currently defined menu items that can be modified by you.
The procedure for modifying the menu items is the same as
for menus and menubuttons. To change the type of the menu
item to be inserted, you select the menubutton in the upper
left corner named \fBMenu entry\fR.
.PP
The most important command is the Tcl command \fBSendToEmacs\fR
that sends the passed parameter to emacs, where this lisp code
is evaluated. If you want to have more direct control over the
sending (i.e. to handle the return value) you can send the lisp
code by typing: \fB.frame.text send {lisp code}\fR. For a more
detailed description of the communication and handling of the
Tcl/Tk - Emacs connection, read the manual for the \fBTkEmacs\fR 
widget.
.PP
To make your changes permanent, you have to select the \fBSave\fR
button in the dialog box for menu and menubutton changing. The 
new definition for the menu layout is stored to the file named
~/.tkemacs-c.tcl.

.SH "MODE SPECIFIC MENUS"
.PP
You can define menus that are specific for a certain emacs
mode. Select the menu item \fBMode specific menus\fR in the
pull-down menu \fBConfigure\fR to change the menus. The
menus are available in the \fBModes\fR menu. The menu for a
mode must have a certain name to be accessible. It must be a
child of the menu which contains the modes, and must have
the same name as the mode where spaces are ignored
(deleted). For Lisp Interaction mode, the name of the popup
menu is: \fB.frame0.menubutton05.m.lispinteraction\fR.

.SH SCROLLBARS
.PP
The linkage between the emacs widget and emacs is not strong
enough to guarantee that the scrollbars are always in the
correct size and at the correct location. Some of the most
important emacs functions (in my opinion :-) update the
scrollbar when they are called as well.

.SH RESOURCES
.PP
You can configure the colors and fonts that \fBtkemacs\fR uses.
These options are changed via the menu item \fBResources\fR in
the pull-down menu \fBConfigure\fR. You have to save your
changes by selecting the menu item \fBSave\fR. The options are
stored to the file named ~/.tkemacs-o.tcl.

.SH ENVIRONMENT
.IP DISPLAY 15
The default display to be used.
.IP CB_COLOR_FILE 15
This variable specifies a file containing a list of all known
colors. This file is automatically created when CIMBuilder is
installed, so please set this variable to the location of the
\fBColors\fR file of the installed CIMBuilder (usually in the
directory ./lib/cb inside the CIMBuilder distribution).
.IP CB_FONT_FILE 15
This variable specifies a file containing a list of all known
fonts. This file is automatically created when CIMBuilder is
installed, so please set this variable to the location of the
\fBFonts\fR file of the installed CIMBuilder (usually in the
directory ./lib/cb inside the CIMBuilder distribution).
.IP CB_LOAD_PATH 15
This variable specifies a list of pathnames (separated by
":") where the tkemacs Tcl source files can be found. In
order to find the Tcl source files, they must be stored in
one of these directories. 

.SH WARNING
.PP
If you use this widget (program), be aware of the fact that it
can cause trouble. It was tested, but as emacs is a complex
system and Tk is a complex system, too, there may still be
some problems. 
.PP
If you encounter any problems, please let us know. If you are
able to locate the bug, please send problems, bug fixes and
ideas to:
.IP "" 15
\fBsven@cimetrix.com\fR
.LP
.PP
Feel free to modify/adapt the sources and to write new lisp
functions for improved functionality. If you do so, please
let us know, so we can improve the widget for us and the
other users (if there are any :-).

.SH BUGS
.\"
.IP "\(bu"
The menu showing the buffers is a little sensitive. It can
happen that you only get the correct pull-down menu after
you have clicked the Buffers menubutton a few times.
Sometimes, the contents of the menu are not correct.
.\"
.IP "\(bu"
Surely, there are many bugs.

.SH KEYWORDS
emacs, wish, tkEmacs, CIMBuilder, reparenting, xaccess
