# TH bindings (created by makebeth) for Button widgets

set TH(Binding,OK) {<Return> <Control-m> <Key-KP_Enter>}
set TH(Binding,Cancel) <Control-g>
set TH(Cmd,Default,Print) {| lpr -m -p -T }
set TH(Cmd,Default,Mail) {| mail -s }
set TH(Tmpfile) /tmp/th.cmd.tmp
set TH(Iterate,Default) 10
set TH(Binding,All_Shown) <Meta-slash>
set TH(Binding,All_Windows) <Meta-question>
bind all <Button-3> {th_toggle_menus %W}
bind all <Meta-n> {th_circle_focus_next %W}
bind all <Meta-p> {th_circle_focus_previous %W}
bind all <Meta-O> {th_cmd_exec_prompt %W "Print Command:" Print}
bind all <Meta-A> {th_cmd_exec_prompt %W "Mail Command:" Mail}
bind all <Meta-W> {th_cmd_wish_prompt %W}
bind all <Meta-E> {th_cmd_exec_prompt %W}
bind all <Control-g> {th_cancel_all %W}
bind all <Meta-T> {th_iterate_binding %W}
bind all <Control-bracketright> {th_geometry_adjust [winfo toplevel %W] 0 -20}
bind all <Control-bracketleft> {th_geometry_adjust [winfo toplevel %W] 1 -20}
bind all <Control-braceright> {th_geometry_adjust [winfo toplevel %W] 0 +20}
bind all <Control-braceleft> {th_geometry_adjust [winfo toplevel %W] 1 +20}
bind all <Meta-I> {th_iconify_window %W}
bind all <Meta-i> {th_raise_window %W}
bind all <Meta-braceright> {th_geometry_adjust [winfo toplevel %W] 2 +20}
bind all <Meta-bracketright> {th_geometry_adjust [winfo toplevel %W] 2 -20}
bind all <Meta-bracketleft> {th_geometry_adjust [winfo toplevel %W] 3 -20}
bind all <Meta-braceleft> {th_geometry_adjust [winfo toplevel %W] 3 +20}
bind all <Meta-Control-bracketright> {th_geometry_change [winfo toplevel %W] 2 0}
bind all <Meta-Control-bracketleft> {th_geometry_change [winfo toplevel %W] 3 0}
bind all <Control-bracketright> {th_resize_widget %W 0 -1 1 20}
bind all <Control-braceright> {th_resize_widget %W 0 +1 1 20}
bind all <Control-bracketleft> {th_resize_widget %W 1 -1 1 20}
bind all <Control-braceleft> {th_resize_widget %W 1 +1 1 20}
bind all <Meta-V> {th_switch_buffer %W}
bind all <Meta-slash> {th_focus_all %W}
bind all <Meta-question> {th_focus_all %W 1}
bind all <Meta-backslash> {th_move_last %W}
bind all <Meta-bar> {th_move_last %W 1}



proc th_Misc_menus {w} {
  global TH
  if {[winfo manager $w] == "pack"} {
    set TH(Menubar,$w) "[set w]_mb"
    pack [frame $TH(Menubar,$w)] -f x -before $w -side top -anchor n
  } else {
    if {[winfo toplevel $w] == "."} {set TH(Menubar,$w) ".mb[th_gensym]"
    } else {set TH(Menubar,$w) "[winfo toplevel $w].mb[th_gensym]"}
    pack [frame $TH(Menubar,$w)] -f x -side top -anchor n -before [lindex [pack slaves [winfo toplevel $TH(Menubar,$w)]] 0]}

set code {


menubutton %W_mb.mb_focus -m %W_mb.mb_focus.m -text Focus -u 1
pack %W_mb.mb_focus -in %W_mb -side left
menu %W_mb.mb_focus.m
%W_mb.mb_focus.m add command -l {Next} -u 0 -acc {<Meta-n>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_circle_focus_next %W}}
%W_mb.mb_focus.m add command -l {Previous} -u 0 -acc {<Meta-p>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_circle_focus_previous %W}}

menubutton %W_mb.mb_command -m %W_mb.mb_command.m -text Command -u 0
pack %W_mb.mb_command -in %W_mb -side left
menu %W_mb.mb_command.m
%W_mb.mb_command.m add cascade -l Commands -u 0 -m %W_mb.mb_command.m.commands
menu %W_mb.mb_command.m.commands
%W_mb.mb_command.m.commands add command -l {Print} -u 0 -acc {<Meta-O>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_cmd_exec_prompt %W "Print Command:" Print}}
%W_mb.mb_command.m.commands add command -l {Mail} -u 1 -acc {<Meta-A>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_cmd_exec_prompt %W "Mail Command:" Mail}}
%W_mb.mb_command.m add checkbutton -variable TH(Cmd,Input,%W)\
  -onvalue 1 -offvalue 0 -l {Get Input} -u 4 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_checkbutton_variable Cmd,Input,%W}}
%W_mb.mb_command.m add checkbutton -variable TH(Cmd,Output,%W)\
  -onvalue 1 -offvalue 0 -l {Insert Output} -u 7 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_checkbutton_variable Cmd,Output,%W}}
%W_mb.mb_command.m add command -l {Wish} -u 0 -acc {<Meta-W>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_cmd_wish_prompt %W}}
%W_mb.mb_command.m add command -l {Exec} -u 0 -acc {<Meta-E>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_cmd_exec_prompt %W}}

menubutton %W_mb.mb_extras -m %W_mb.mb_extras.m -text Extras -u 1
pack %W_mb.mb_extras -in %W_mb -side left
menu %W_mb.mb_extras.m
%W_mb.mb_extras.m add command -l {Abort} -u 0 -acc {<Control-g>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_cancel_all %W}}
%W_mb.mb_extras.m add command -l {Iterate} -u 1 -acc {<Meta-T>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_iterate_binding %W}}

menubutton %W_mb.mb_window -m %W_mb.mb_window.m -text Window -u 0
pack %W_mb.mb_window -in %W_mb -side left
menu %W_mb.mb_window.m
%W_mb.mb_window.m add cascade -l Resize -u 2 -m %W_mb.mb_window.m.resize
menu %W_mb.mb_window.m.resize
%W_mb.mb_window.m.resize add command -l {Shrink Horizontally} -u 0 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_adjust [winfo toplevel %W] 0 -20}}
%W_mb.mb_window.m.resize add command -l {Shrink Vertically} -u 1 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_adjust [winfo toplevel %W] 1 -20}}
%W_mb.mb_window.m.resize add command -l {Expand Horizontally} -u 0 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_adjust [winfo toplevel %W] 0 +20}}
%W_mb.mb_window.m.resize add command -l {Expand Vertically} -u 1 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_adjust [winfo toplevel %W] 1 +20}}
%W_mb.mb_window.m add command -l {Iconify} -u 0 -acc {<Meta-I>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_iconify_window %W}}
%W_mb.mb_window.m add command -l {Raise} -u 0 -acc {<Meta-i>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_raise_window %W}}
%W_mb.mb_window.m add cascade -l Move -u 0 -m %W_mb.mb_window.m.move
menu %W_mb.mb_window.m.move
%W_mb.mb_window.m.move add command -l {Right} -u 0 -acc {<Meta-braceright>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_adjust [winfo toplevel %W] 2 +20}}
%W_mb.mb_window.m.move add command -l {Left} -u 0 -acc {<Meta-bracketright>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_adjust [winfo toplevel %W] 2 -20}}
%W_mb.mb_window.m.move add command -l {Up} -u 0 -acc {<Meta-bracketleft>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_adjust [winfo toplevel %W] 3 -20}}
%W_mb.mb_window.m.move add command -l {Down} -u 0 -acc {<Meta-braceleft>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_adjust [winfo toplevel %W] 3 +20}}
%W_mb.mb_window.m.move add command -l {Left Edge} -u 5 -acc {<Meta-Control-bracketright>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_change [winfo toplevel %W] 2 0}}
%W_mb.mb_window.m.move add command -l {Top Edge} -u 0 -acc {<Meta-Control-bracketleft>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_geometry_change [winfo toplevel %W] 3 0}}
%W_mb.mb_window.m.resize entryconfigure {Shrink Horizontally} -u 0 -acc {<Control-bracketright>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_resize_widget %W 0 -1 1 20}}
%W_mb.mb_window.m.resize entryconfigure {Expand Horizontally} -u 0 -acc {<Control-braceright>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_resize_widget %W 0 +1 1 20}}
%W_mb.mb_window.m.resize entryconfigure {Shrink Vertically} -u 1 -acc {<Control-bracketleft>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_resize_widget %W 1 -1 1 20}}
%W_mb.mb_window.m.resize entryconfigure {Expand Vertically} -u 1 -acc {<Control-braceleft>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_resize_widget %W 1 +1 1 20}}
%W_mb.mb_focus.m add command -l {Window} -u 0 -acc {<Meta-V>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_switch_buffer %W}}
%W_mb.mb_focus.m add command -l {All Shown Windows} -u 1 -acc {<Meta-slash>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_focus_all %W}}
%W_mb.mb_focus.m add command -l {All Windows} -u 0 -acc {<Meta-question>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_focus_all %W 1}}
%W_mb.mb_window.m.move add command -l {Below Last} -u 0 -acc {<Meta-backslash>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_move_last %W}}
%W_mb.mb_window.m.move add command -l {Right of Last} -u 1 -acc {<Meta-bar>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_move_last %W 1}}


}

regsub -all "%W_mb" $code $TH(Menubar,$w) new_code
regsub -all %W $new_code $w code
eval $code

}
