# TH bindings (created by makebeth) for Text widgets

set TH(Undo,Max,Text) -1
set TH(Undo,Label,Max) 30
set TH(Binding,Kill_Line) <Control-c>
set TH(File,Browse,Command) {|ls -lFa}
set TH(Pipe,Enabled) 1
set TH(Binding,Search_Forward) <Control-s>
set TH(Menuentry,Search_Forward) {Forward 0}
set TH(Binding,Search_Backward) <Control-r>
set TH(Menuentry,Search_Backward) {Reverse 0}
set TH(Binding,Toggle_Case_Sensitivity) <Meta-Control-c>
set TH(Menuentry,Toggle_Case_Sensitivity) {"Case Inensitive" 0}
set TH(Binding,Toggle_Incremental_Search) <Meta-C>
set TH(Menuentry,Toggle_Incremental_Search) {"Incremental Search" 0}
set TH(Search,Select,Text) sel
set TH(Search,Case,Implicit) 1
set TH(Binding,Replace_One) <Control-c>
set TH(Menuentry,Replace_One) {"Replace One" 8}
set TH(Binding,Replace_All) <Control-C>
set TH(Menuentry,Replace_All) {"Replace All" 8}
set TH(Binding,Highlight_Searches) <Meta-Control-l>
set TH(Menuentry,Highlight_Searches) {Highlight 4}
set TH(Binding,Mark_Text) <Control-Key-M>
set TH(Menuentry,Mark_Text) {Mark 0}
set TH(Binding,Unmark_Text) <Meta-Key-M>
set TH(Menuentry,Unmark_Text) {Unmark 0}
set TH(Search,Text,Oldtag) {-background yellow4 -foreground white}
set TH(Replace,Tag) {-background orange4 -foreground white}
set TH(Binding,Complete_Word) <Escape>
set TH(Binding,Show_Completions) <Control-Escape>
set TH(Completions,Text) {{th_line_complete th_filter_history none} {th_substring_replace th_string_tcl_result {[}} {th_substring_replace th_string_global_value {$}} {th_substring_replace th_string_glob_files { }} {th_substring_complete th_filter_cmds {[}} {th_substring_complete th_filter_vars {$}} {th_substring_complete th_filter_glob { }}}
set TH(Mark,Tag) {-background blue}
set TH(Paint,Test,Tag) {-foreground grey -relief raised}
set TH(Paren,Select,Text) sel
set TH(Paren,Length) 30
set TH(Paren,Show,Text) 0
th_Misc_paren_initialize Text
th_Misc_paren_add Text \[ \]
th_Misc_paren_add Text \{ \}
th_Misc_paren_add Text \( \)
set TH(Tag,Menu,Length) 30
set TH(Tag,Entries,Max) 20
set TH(Tag,Select) 1
set TH(Tag,Empty) 0
bind Text <Button-3> {th_toggle_menus %W}
bind Text <Control-l> {th_Text_center_cursor %W}
bind Text <Control-b> {th_Text_goto %W {insert -1c}}
bind Text <Control-f> {th_Text_goto %W {insert +1c}}
bind Text <Control-p> {th_Text_goto %W [tkTextUpDownLine %W -1]}
bind Text <Control-n> {th_Text_goto %W [tkTextUpDownLine %W  1]}
bind Text <Meta-comma> {th_Text_goto %W [th_Text_adjacent_line %W -1]}
bind Text <Meta-period> {th_Text_goto %W [th_Text_adjacent_line %W +1]}
bind Text <Meta-b> {th_Text_goto %W {insert -1c wordstart}}
bind Text <Meta-f> {th_Text_goto %W {insert wordend}}
bind Text <Control-comma> {th_Text_goto %W "@0,[lindex [%W bbox insert] 1]"}
bind Text <Control-period> {th_Text_goto %W "@[winfo width %W],[lindex [%W bbox insert] 1]"}
bind Text <Control-less> {th_Text_goto %W @0,0}
bind Text <Control-greater> {th_Text_goto %W "@[winfo width %W],[winfo height %W]"}
bind Text <Control-a> {th_Text_goto %W "insert linestart"}
bind Text <Control-e> {th_Text_goto %W "insert lineend"}
bind Text <Meta-less> {th_Text_goto %W 1.0}
bind Text <Meta-greater> {th_Text_goto %W end}
bind Text <Control-L> {th_Text_goto %W "@[expr [winfo width %W] / 2],[expr [winfo height %W] / 2]"}
bind Text <Control-K> {th_Text_select_next_line %W}
bind Text <Control-Shift-space> {th_Text_select_to %W insert}
bind Text <Control-slash> {%W tag add sel 1.0 end}
bind Text <Control-space> {%W mark set anchor insert}
bind Text <Control-x> {th_[winfo class %W]_exchange_mark %W}
bind Text <Meta-g> {th_goto %W}
bind Text <Control-backslash> {selection clear -displayof %W}
bind Text <Meta-w> {if {[selection own -displayof %W] == "%W"} {
	    clipboard clear -displayof %W
	    clipboard append -displayof %W -- [selection get -displayof %W]}}
bind Text <Meta-Z> {th_scroll %W xview scroll -1 units}
bind Text <Control-Z> {th_scroll %W xview scroll  1 units}
bind Text <Meta-asciitilde> {th_scroll %W xview scroll -1 pages}
bind Text <Control-asciitilde> {th_scroll %W xview scroll  1 pages}
bind Text <Meta-z> {th_scroll %W yview scroll -1 units}
bind Text <Control-z> {th_scroll %W yview scroll  1 units}
bind Text <Meta-quoteleft> {th_scroll %W yview scroll -1 pages}
bind Text <Control-quoteleft> {th_scroll %W yview scroll  1 pages}
bind Text <Control-g> {th_cancel_all %W}
bind Text <Meta-Control-u> {th_[winfo class %W]_undo %W}
bind Text <Meta-Control-l> {th_look_undo %W}
bind Text <Meta-Control-k> {th_kill_undos %W}
bind Text <Control-y> {th_paste_selection %W -selection CLIPBOARD}
bind Text <Control-v> {th_paste_selection %W}
bind Text <ButtonRelease-2> {if !$tkPriv(mouseMoved) {th_paste_selection %W}}
bind Text <Control-q> {th_quote %W}
bind Text <Control-w> {th_[winfo class %W]_kill_region %W}
foreach th_binding {<Control-BackSpace> <Delete>} {
 bind Text $th_binding {th_[winfo class %W]_delete_selection %W}}
bind Text <Meta-u> {th_[winfo class %W]_filter %W th_string_toupper}
bind Text <Meta-l> {th_[winfo class %W]_filter %W th_string_tolower}
bind Text <Meta-c> {th_[winfo class %W]_filter %W th_string_capitalize}
bind Text <Control-t> {th_[winfo class %W]_transpose_chars %W}
bind Text <Meta-t> {th_[winfo class %W]_transpose_words %W}
bind Text <Control-c> {th_Text_kill_line %W}
foreach th_binding {<Control-h> <BackSpace>} {
 bind Text $th_binding {th_Text_delete_range %W {insert -1 char} insert 0}}
bind Text <Control-d> {th_Text_delete_range %W insert {insert +1 char} 0}
foreach th_binding {<Meta-h> <Meta-BackSpace>} {
 bind Text $th_binding {th_Text_delete_range %W {insert -1 chars wordstart} insert}}
bind Text <Meta-d> {th_Text_delete_range %W insert {insert wordend}}
bind Text <Control-k> {if [%W compare insert == {insert lineend}] {th_Text_delete_range %W insert insert+1c 1 1} else {th_Text_delete_range %W insert {insert lineend} 1 1}}
bind Text <Control-o> {th_Text_insert %W "\n" ; %W mark set insert "insert -1c" ; %W yview -pickplace insert}
bind Text <Control-i> {th_indent %W th_Text_indent}
bind Text <Control-I> {th_indent %W th_Text_indent_delete}
foreach th_binding {<Return> <Control-m> <Key-KP_Enter>} {
 bind Text $th_binding {th_[winfo class %W]_insert %W "\n"}}
bind Text <Meta-o> {th_checkbutton_variable Overwrite,%W}
bind Text <Key> {th_[winfo class %W]_self_insert %W %A}
bind Text <Meta-F> {th_confirm_save %W {th_file_move %W 1}}
bind Text <Meta-B> {th_confirm_save %W {th_file_move %W -1}}
bind Text <Meta-N> {th_confirm_save %W {th_file_down %W}}
bind Text <Meta-P> {th_confirm_save %W {th_file_up %W}}
bind Text <Meta-s> {th_save_file %W}
bind Text <Meta-S> {th_save_file_prompt %W}
bind Text <Meta-r> {th_read_file %W}
bind Text <Meta-R> {th_read_file_prompt %W}
bind Text <Meta-Control-r> {th_insert_file %W}
bind Text <Meta-x> {th_[winfo class %W]_toggle_grid_x %W bottom}
bind Text <Meta-y> {th_[winfo class %W]_toggle_grid_y %W left}
bind Text <Control-s> {th_Misc_search %W forward string}
bind Text <Control-r> {th_Misc_search %W backward string}
bind Text <Control-S> {th_Misc_search %W forward regexp}
bind Text <Control-R> {th_Misc_search %W backward regexp}
bind Text <Meta-C> {th_toggle_incremental_search %W}
bind Text <Escape> {th_[winfo class %W]_complete_multiple %W [th_completions %W]}
bind Text <Control-Escape> {th_[winfo class %W]_completion_dialog %W}
bind Text <Control-F> {th_mark_forward %W}
bind Text <Control-B> {th_mark_backward %W}
bind Text <Control-Key-M> {th_mark_region %W}
bind Text <Meta-Key-M> {th_unmark_region %W}
bind Text <Control-U> {th_busy %W th_Text_paint_region %W @0,0 @0,[winfo height %W]}
bind Text <Meta-U> {th_busy %W th_Text_paint_region %W 1.0 end}
bind Text <Meta-X> {th_toggle_scrollbar %W x bottom}
bind Text <Meta-Y> {th_toggle_scrollbar %W y left}
bind Text <Meta-space> {th_Misc_exp_check %W}
bind Text <Key> {th_Misc_exp_check_self %W %A}
bind Text <Meta-a> {th_[winfo class %W]_goto %W [th_Misc_left_exp %W]}
bind Text <Meta-e> {th_[winfo class %W]_goto %W [th_Misc_right_exp %W]}
bind Text <Meta-Shift-space> {th_Misc_select_exp %W}
bind Text <Meta-Key-1> {th_add_module paragrath %W}
bind Text <Meta-Key-2> {th_add_module tclth %W}
bind Text <Meta-Key-3> {th_add_module cth %W}
bind Text <Meta-Key-4> {th_add_module lispth %W}
bind Text <Meta-Key-5> {th_add_module htmlth %W}
bind Text <Meta-Key-6> {th_add_module msgth %W}



proc th_Text_menus {w} {
  th_Misc_menus $w
set code {

menubutton %W_mb.mb_index -m %W_mb.mb_index.m -text Index -u 0
pack %W_mb.mb_index -in %W_mb -side left
menu %W_mb.mb_index.m
%W_mb.mb_index.m add cascade -l Tags -u 0 -m %W_mb.mb_index.m.tags
menu %W_mb.mb_index.m.tags
%W_mb.mb_index.m.tags add command -l {Useless} -u 0 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  }}
%W_mb.mb_index.m.tags configure -postcommand {th_Text_make_tags_menu %W}

menubutton %W_mb.mb_browse -m %W_mb.mb_browse.m -text Browse -u 0
pack %W_mb.mb_browse -in %W_mb -side left
menu %W_mb.mb_browse.m
%W_mb.mb_browse.m add cascade -l Scroll -u 0 -m %W_mb.mb_browse.m.scroll
menu %W_mb.mb_browse.m.scroll
%W_mb.mb_browse.m.scroll add command -l {Center Cursor} -u 0 -acc {<Control-l>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_center_cursor %W}}
%W_mb.mb_browse.m add cascade -l Goto -u 0 -m %W_mb.mb_browse.m.goto
menu %W_mb.mb_browse.m.goto
%W_mb.mb_browse.m.goto add cascade -l Character -u 0 -m %W_mb.mb_browse.m.goto.character
menu %W_mb.mb_browse.m.goto.character
%W_mb.mb_browse.m.goto.character add command -l {Left} -u 0 -acc {<Control-b>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W {insert -1c}}}
%W_mb.mb_browse.m.goto.character add command -l {Right} -u 0 -acc {<Control-f>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W {insert +1c}}}
%W_mb.mb_browse.m.goto.character add command -l {Previous} -u 0 -acc {<Control-p>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W [tkTextUpDownLine %W -1]}}
%W_mb.mb_browse.m.goto.character add command -l {Next} -u 0 -acc {<Control-n>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W [tkTextUpDownLine %W  1]}}
%W_mb.mb_browse.m.goto.character add command -l {Up} -u 0 -acc {<Meta-comma>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W [th_Text_adjacent_line %W -1]}}
%W_mb.mb_browse.m.goto.character add command -l {Down} -u 0 -acc {<Meta-period>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W [th_Text_adjacent_line %W +1]}}
%W_mb.mb_browse.m.goto add cascade -l Word -u 0 -m %W_mb.mb_browse.m.goto.word
menu %W_mb.mb_browse.m.goto.word
%W_mb.mb_browse.m.goto.word add command -l {Left} -u 0 -acc {<Meta-b>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W {insert -1c wordstart}}}
%W_mb.mb_browse.m.goto.word add command -l {Right} -u 0 -acc {<Meta-f>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W {insert wordend}}}
%W_mb.mb_browse.m.goto add cascade -l Screen -u 0 -m %W_mb.mb_browse.m.goto.screen
menu %W_mb.mb_browse.m.goto.screen
%W_mb.mb_browse.m.goto.screen add command -l {Left} -u 0 -acc {<Control-comma>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W "@0,[lindex [%W bbox insert] 1]"}}
%W_mb.mb_browse.m.goto.screen add command -l {Right} -u 0 -acc {<Control-period>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W "@[winfo width %W],[lindex [%W bbox insert] 1]"}}
%W_mb.mb_browse.m.goto.screen add command -l {Up} -u 0 -acc {<Control-less>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W @0,0}}
%W_mb.mb_browse.m.goto.screen add command -l {Down} -u 0 -acc {<Control-greater>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W "@[winfo width %W],[winfo height %W]"}}
%W_mb.mb_browse.m.goto add cascade -l Edge -u 0 -m %W_mb.mb_browse.m.goto.edge
menu %W_mb.mb_browse.m.goto.edge
%W_mb.mb_browse.m.goto.edge add command -l {Left} -u 0 -acc {<Control-a>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W "insert linestart"}}
%W_mb.mb_browse.m.goto.edge add command -l {Right} -u 0 -acc {<Control-e>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W "insert lineend"}}
%W_mb.mb_browse.m.goto.edge add command -l {Up} -u 0 -acc {<Meta-less>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W 1.0}}
%W_mb.mb_browse.m.goto.edge add command -l {Down} -u 0 -acc {<Meta-greater>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W end}}
%W_mb.mb_browse.m.goto add command -l {Center of Screen} -u 5 -acc {<Control-L>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_goto %W "@[expr [winfo width %W] / 2],[expr [winfo height %W] / 2]"}}
%W_mb.mb_browse.m add cascade -l Select -u 1 -m %W_mb.mb_browse.m.select
menu %W_mb.mb_browse.m.select
%W_mb.mb_browse.m.select add command -l {Line} -u 0 -acc {<Control-K>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_select_next_line %W}}
%W_mb.mb_browse.m.select add command -l {Region} -u 0 -acc {<Control-Shift-space>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_select_to %W insert}}
%W_mb.mb_browse.m.select add command -l {All} -u 0 -acc {<Control-slash>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  %W tag add sel 1.0 end}}
%W_mb.mb_browse.m add command -l {Anchor} -u 0 -acc {<Control-space>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  %W mark set anchor insert}}
%W_mb.mb_browse.m.goto add command -l {Anchor} -u 0 -acc {<Control-x>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_exchange_mark %W}}
%W_mb.mb_browse.m.goto add command -l {Specify an Index} -u 11 -acc {<Meta-g>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_goto %W}}
%W_mb.mb_browse.m.select add command -l {Clear} -u 0 -acc {<Control-backslash>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  selection clear -displayof %W}}
%W_mb.mb_browse.m.select add command -l {Copy} -u 1 -acc {<Meta-w>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  if {[selection own -displayof %W] == "%W"} {
	    clipboard clear -displayof %W
	    clipboard append -displayof %W -- [selection get -displayof %W]}}}
%W_mb.mb_browse.m.scroll add cascade -l Line -u 0 -m %W_mb.mb_browse.m.scroll.line
menu %W_mb.mb_browse.m.scroll.line
%W_mb.mb_browse.m.scroll.line add command -l {Left} -u 0 -acc {<Meta-Z>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_scroll %W xview scroll -1 units}}
%W_mb.mb_browse.m.scroll.line add command -l {Right} -u 0 -acc {<Control-Z>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_scroll %W xview scroll  1 units}}
%W_mb.mb_browse.m.scroll add cascade -l Page -u 0 -m %W_mb.mb_browse.m.scroll.page
menu %W_mb.mb_browse.m.scroll.page
%W_mb.mb_browse.m.scroll.page add command -l {Left} -u 0 -acc {<Meta-asciitilde>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_scroll %W xview scroll -1 pages}}
%W_mb.mb_browse.m.scroll.page add command -l {Right} -u 0 -acc {<Control-asciitilde>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_scroll %W xview scroll  1 pages}}
%W_mb.mb_browse.m.scroll.line add command -l {Up} -u 0 -acc {<Meta-z>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_scroll %W yview scroll -1 units}}
%W_mb.mb_browse.m.scroll.line add command -l {Down} -u 0 -acc {<Control-z>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_scroll %W yview scroll  1 units}}
%W_mb.mb_browse.m.scroll.page add command -l {Up} -u 0 -acc {<Meta-quoteleft>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_scroll %W yview scroll -1 pages}}
%W_mb.mb_browse.m.scroll.page add command -l {Down} -u 0 -acc {<Control-quoteleft>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_scroll %W yview scroll  1 pages}}

menubutton %W_mb.mb_edit -m %W_mb.mb_edit.m -text Edit -u 0
pack %W_mb.mb_edit -in %W_mb -side left
menu %W_mb.mb_edit.m
%W_mb.mb_edit.m add cascade -l Undo -u 0 -m %W_mb.mb_edit.m.undo
menu %W_mb.mb_edit.m.undo
%W_mb.mb_edit.m.undo add command -l {Undo} -u 0 -acc {<Meta-Control-u>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_undo %W}}
%W_mb.mb_edit.m.undo add command -l {Show Last} -u 5 -acc {<Meta-Control-l>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_look_undo %W}}
%W_mb.mb_edit.m.undo add command -l {Kill Undo Log} -u 0 -acc {<Meta-Control-k>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_kill_undos %W}}
%W_mb.mb_edit.m add cascade -l Paste -u 0 -m %W_mb.mb_edit.m.paste
menu %W_mb.mb_edit.m.paste
%W_mb.mb_edit.m.paste add command -l {Clipboard} -u 0 -acc {<Control-y>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_paste_selection %W -selection CLIPBOARD}}
%W_mb.mb_edit.m.paste add command -l {Selection} -u 0 -acc {<Control-v>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_paste_selection %W}}
%W_mb.mb_edit.m add command -l {Quote} -u 0 -acc {<Control-q>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_quote %W}}
%W_mb.mb_edit.m add cascade -l Cut -u 0 -m %W_mb.mb_edit.m.cut
menu %W_mb.mb_edit.m.cut
%W_mb.mb_edit.m.cut add command -l {Region} -u 0 -acc {<Control-w>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_kill_region %W}}
%W_mb.mb_edit.m add cascade -l Delete -u 0 -m %W_mb.mb_edit.m.delete
menu %W_mb.mb_edit.m.delete
%W_mb.mb_edit.m.delete add command -l {Selection} -u 0 -acc {<Control-BackSpace>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_delete_selection %W}}
%W_mb.mb_edit.m add cascade -l Case -u 1 -m %W_mb.mb_edit.m.case
menu %W_mb.mb_edit.m.case
%W_mb.mb_edit.m.case add command -l {Upper} -u 0 -acc {<Meta-u>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_filter %W th_string_toupper}}
%W_mb.mb_edit.m.case add command -l {Lower} -u 0 -acc {<Meta-l>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_filter %W th_string_tolower}}
%W_mb.mb_edit.m.case add command -l {Capitalize} -u 0 -acc {<Meta-c>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_filter %W th_string_capitalize}}
%W_mb.mb_edit.m add cascade -l Transpose -u 0 -m %W_mb.mb_edit.m.transpose
menu %W_mb.mb_edit.m.transpose
%W_mb.mb_edit.m.transpose add command -l {Characters} -u 0 -acc {<Control-t>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_transpose_chars %W}}
%W_mb.mb_edit.m.transpose add command -l {Words} -u 0 -acc {<Meta-t>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_transpose_words %W}}
%W_mb.mb_edit.m.cut add command -l {Line} -u 0 -acc {<Control-c>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_kill_line %W}}
%W_mb.mb_edit.m.delete add cascade -l Character -u 0 -m %W_mb.mb_edit.m.delete.character
menu %W_mb.mb_edit.m.delete.character
%W_mb.mb_edit.m.delete.character add command -l {Previous} -u 0 -acc {<Control-h>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_delete_range %W {insert -1 char} insert 0}}
%W_mb.mb_edit.m.delete.character add command -l {Next} -u 0 -acc {<Control-d>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_delete_range %W insert {insert +1 char} 0}}
%W_mb.mb_edit.m.delete add cascade -l Word -u 0 -m %W_mb.mb_edit.m.delete.word
menu %W_mb.mb_edit.m.delete.word
%W_mb.mb_edit.m.delete.word add command -l {Previous} -u 0 -acc {<Meta-h>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_delete_range %W {insert -1 chars wordstart} insert}}
%W_mb.mb_edit.m.delete.word add command -l {Next} -u 0 -acc {<Meta-d>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_delete_range %W insert {insert wordend}}}
%W_mb.mb_edit.m.delete add command -l {Line} -u 0 -acc {<Control-k>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  if [%W compare insert == {insert lineend}] {th_Text_delete_range %W insert insert+1c 1 1} else {th_Text_delete_range %W insert {insert lineend} 1 1}}}
%W_mb.mb_edit.m add command -l {Split Line} -u 0 -acc {<Control-o>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Text_insert %W "\n" ; %W mark set insert "insert -1c" ; %W yview -pickplace insert}}
%W_mb.mb_edit.m add cascade -l Indent -u 0 -m %W_mb.mb_edit.m.indent
menu %W_mb.mb_edit.m.indent
%W_mb.mb_edit.m.indent add command -l {Insert} -u 0 -acc {<Control-i>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_indent %W th_Text_indent}}
%W_mb.mb_edit.m.indent add command -l {Delete} -u 0 -acc {<Control-I>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_indent %W th_Text_indent_delete}}
%W_mb.mb_edit.m add checkbutton -variable TH(Overwrite,%W)\
  -onvalue 1 -offvalue 0 -l {Toggle Overwrite} -u 7 -acc {<Meta-o>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_checkbutton_variable Overwrite,%W}}

menubutton %W_mb.mb_file -m %W_mb.mb_file.m -text File -u 0
pack %W_mb.mb_file -in %W_mb -side left
menu %W_mb.mb_file.m
%W_mb.mb_file.m add cascade -l Browse -u 0 -m %W_mb.mb_file.m.browse
menu %W_mb.mb_file.m.browse
%W_mb.mb_file.m.browse add command -l {Forward} -u 0 -acc {<Meta-F>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_confirm_save %W {th_file_move %W 1}}}
%W_mb.mb_file.m.browse add command -l {Backward} -u 0 -acc {<Meta-B>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_confirm_save %W {th_file_move %W -1}}}
%W_mb.mb_file.m.browse add command -l {Down} -u 3 -acc {<Meta-N>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_confirm_save %W {th_file_down %W}}}
%W_mb.mb_file.m.browse add command -l {Up} -u 1 -acc {<Meta-P>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_confirm_save %W {th_file_up %W}}}
%W_mb.mb_file.m add command -l {Save} -u 0 -acc {<Meta-s>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_save_file %W}}
%W_mb.mb_file.m add command -l {Save As} -u 5 -acc {<Meta-S>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_save_file_prompt %W}}
%W_mb.mb_file.m add command -l {Revert} -u 1 -acc {<Meta-r>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_read_file %W}}
%W_mb.mb_file.m add command -l {Read} -u 0 -acc {<Meta-R>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_read_file_prompt %W}}
%W_mb.mb_file.m add command -l {Insert} -u 0 -acc {<Meta-Control-r>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_insert_file %W}}
%W_mb.mb_file.m add checkbutton -variable TH(Pipe)\
  -onvalue 1 -offvalue 0 -l {Use a Pipe} -u 6 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_checkbutton_variable Pipe}}
%W_mb.mb_window.m add checkbutton -variable TH(Grid_X,%W)\
  -onvalue 1 -offvalue 0 -l {Horizontal Grid} -u 0 -acc {<Meta-x>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_toggle_grid_x %W bottom}}
%W_mb.mb_window.m add checkbutton -variable TH(Grid_Y,%W)\
  -onvalue 1 -offvalue 0 -l {Vertical Grid} -u 0 -acc {<Meta-y>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_toggle_grid_y %W left}}

menubutton %W_mb.mb_search -m %W_mb.mb_search.m -text Search -u 0
pack %W_mb.mb_search -in %W_mb -side left
menu %W_mb.mb_search.m
%W_mb.mb_search.m add cascade -l String -u 0 -m %W_mb.mb_search.m.string
menu %W_mb.mb_search.m.string
%W_mb.mb_search.m.string add command -l {Forward} -u 0 -acc {<Control-s>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_search %W forward string}}
%W_mb.mb_search.m.string add command -l {Reverse} -u 0 -acc {<Control-r>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_search %W backward string}}
%W_mb.mb_search.m add cascade -l Regexp -u 0 -m %W_mb.mb_search.m.regexp
menu %W_mb.mb_search.m.regexp
%W_mb.mb_search.m.regexp add command -l {Forward} -u 0 -acc {<Control-S>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_search %W forward regexp}}
%W_mb.mb_search.m.regexp add command -l {Reverse} -u 0 -acc {<Control-R>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_search %W backward regexp}}
%W_mb.mb_search.m add checkbutton -variable TH(Search,Incremental,%W)\
  -onvalue 1 -offvalue 0 -l {Incremental Search} -u 0 -acc {<Meta-C>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_toggle_incremental_search %W}}
%W_mb.mb_extras.m add command -l {Complete} -u 0 -acc {<Escape>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_complete_multiple %W [th_completions %W]}}
%W_mb.mb_extras.m add command -l {Show Completions} -u 0 -acc {<Control-Escape>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_completion_dialog %W}}
%W_mb.mb_browse.m.goto add cascade -l Mark -u 0 -m %W_mb.mb_browse.m.goto.mark
menu %W_mb.mb_browse.m.goto.mark
%W_mb.mb_browse.m.goto.mark add command -l {Forward} -u 0 -acc {<Control-F>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_mark_forward %W}}
%W_mb.mb_browse.m.goto.mark add command -l {Backward} -u 0 -acc {<Control-B>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_mark_backward %W}}
%W_mb.mb_browse.m add cascade -l Mark -u 0 -m %W_mb.mb_browse.m.mark
menu %W_mb.mb_browse.m.mark
%W_mb.mb_browse.m.mark add command -l {Mark} -u 0 -acc {<Control-Key-M>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_mark_region %W}}
%W_mb.mb_browse.m.mark add command -l {Unmark} -u 0 -acc {<Meta-Key-M>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_unmark_region %W}}
%W_mb.mb_index.m add command -l {Update Page} -u 7 -acc {<Control-U>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_busy %W th_Text_paint_region %W @0,0 @0,[winfo height %W]}}
%W_mb.mb_index.m add command -l {Update All} -u 7 -acc {<Meta-U>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_busy %W th_Text_paint_region %W 1.0 end}}
%W_mb.mb_window.m add checkbutton -variable TH(Scrollbar,X,%W)\
  -onvalue 1 -offvalue 0 -l {X Scrollbar} -u 0 -acc {<Meta-X>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_toggle_scrollbar %W x bottom}}
%W_mb.mb_window.m add checkbutton -variable TH(Scrollbar,Y,%W)\
  -onvalue 1 -offvalue 0 -l {Y Scrollbar} -u 0 -acc {<Meta-Y>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_toggle_scrollbar %W y left}}
%W_mb.mb_extras.m add command -l {Check Expression} -u 0 -acc {<Meta-space>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_exp_check %W}}
%W_mb.mb_browse.m.goto add cascade -l Expression -u 1 -m %W_mb.mb_browse.m.goto.expression
menu %W_mb.mb_browse.m.goto.expression
%W_mb.mb_browse.m.goto.expression add command -l {Left} -u 0 -acc {<Meta-a>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_goto %W [th_Misc_left_exp %W]}}
%W_mb.mb_browse.m.goto.expression add command -l {Right} -u 0 -acc {<Meta-e>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_goto %W [th_Misc_right_exp %W]}}
%W_mb.mb_browse.m.select add command -l {Expression} -u 1 -acc {<Meta-Shift-space>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_select_exp %W}}

menubutton %W_mb.mb_modules -m %W_mb.mb_modules.m -text Modules -u 0
pack %W_mb.mb_modules -in %W_mb -side left
menu %W_mb.mb_modules.m
%W_mb.mb_modules.m add command -l {Paragraph} -u 0 -acc {<Meta-Key-1>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_add_module paragrath %W}}
%W_mb.mb_modules.m add command -l {Tcl/Tk} -u 0 -acc {<Meta-Key-2>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_add_module tclth %W}}
%W_mb.mb_modules.m add command -l {C/C++} -u 0 -acc {<Meta-Key-3>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_add_module cth %W}}
%W_mb.mb_modules.m add command -l {Lisp/Scheme} -u 0 -acc {<Meta-Key-4>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_add_module lispth %W}}
%W_mb.mb_modules.m add command -l {HTML} -u 0 -acc {<Meta-Key-5>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_add_module htmlth %W}}
%W_mb.mb_modules.m add command -l {Messages} -u 0 -acc {<Meta-Key-6>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_add_module msgth %W}}


}

global TH
regsub -all "%W_mb" $code $TH(Menubar,$w) new_code
regsub -all %W $new_code $w code
eval $code
}


set TH(Module,Code,paragrath) {
%T configure -wrap word
set TH(Para,Narrow,%T) 1
set TH(Paint,Hook,%T) {th_Text_tag_regions %T PARAGRAPH th_para_begin th_para_end th_para_next $start $end}
%T tag configure PARAGRAPH -background MidnightBlue
%T tag raise sel


bind %T <Control-N> {th_Text_goto %W [th_para_next %W insert]}
bind %T <Control-P> {th_Text_goto %W [th_para_prev %W insert]}
foreach th_binding {<Control-j> <Meta-Button-1>} {
 bind %T $th_binding {th_Text_select_group %W th_para_begin th_para_end}}
bind %T <Control-T> {th_Text_para_change %W th_Text_split}
bind %T <Control-J> {th_Text_para_change %W th_Text_join}
bind %T <Meta-j> {th_Text_para_change %W th_Text_format}
foreach th_binding {<Return> <Control-m> <Key-KP_Enter>} {
 bind %T $th_binding {if $TH(Para,Narrow,%W) {th_Text_split %W [th_para_begin %W insert-1c] insert-1c}}}
bind %T <Control-i> {if $TH(Para,Narrow,%W) {th_bind "[th_frame %W].indent.e" OK "th_Text_para_indent %W"}}
bind %T <Control-I> {if $TH(Para,Narrow,%W) {th_bind "[th_frame %W].indent.e" OK "th_Text_para_indent %W 1"}}
bind %T <Meta-J> {th_checkbutton_variable Para,Narrow,%W}
bind %T <Control-g> {th_cancel_all %W}



th_add_menucode %T {
%M_mb.mb_browse.m.goto add cascade -l Paragraph -u 0 -m %M_mb.mb_browse.m.goto.paragraph
menu %M_mb.mb_browse.m.goto.paragraph
%M_mb.mb_browse.m.goto.paragraph add command -l {Next} -u 0 -acc {<Control-N>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_para_next %M insert]}}
%M_mb.mb_browse.m.goto.paragraph add command -l {Previous} -u 0 -acc {<Control-P>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_para_prev %M insert]}}
%M_mb.mb_browse.m.select add command -l {Paragraph} -u 0 -acc {<Control-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_para_begin th_para_end}}
%M_mb.mb_edit.m add cascade -l Paragraph -u 0 -m %M_mb.mb_edit.m.paragraph
menu %M_mb.mb_edit.m.paragraph
%M_mb.mb_edit.m.paragraph add command -l {Split} -u 4 -acc {<Control-T>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_para_change %M th_Text_split}}
%M_mb.mb_edit.m.paragraph add command -l {Join} -u 0 -acc {<Control-J>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_para_change %M th_Text_join}}
%M_mb.mb_edit.m.paragraph add command -l {Format} -u 1 -acc {<Meta-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_para_change %M th_Text_format}}
%M_mb.mb_edit.m.indent entryconfigure {Insert} -u 0 -acc {<Control-i>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  if $TH(Para,Narrow,%M) {th_bind "[th_frame %M].indent.e" OK "th_Text_para_indent %M"}}}
%M_mb.mb_edit.m.indent entryconfigure {Delete} -u 0 -acc {<Control-I>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  if $TH(Para,Narrow,%M) {th_bind "[th_frame %M].indent.e" OK "th_Text_para_indent %M 1"}}}
%M_mb.mb_extras.m add checkbutton -variable TH(Para,Narrow,%M)\
  -onvalue 1 -offvalue 0 -l {Narrow Paragraphs} -u 7 -acc {<Meta-J>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_checkbutton_variable Para,Narrow,%M}}


}}
set TH(Module,Code,tclth) {
set TH(Paint,Hook,%T) {th_Text_tag_regions %T FUNCTION th_proc_begin th_proc_end th_proc_next $start $end}
%T tag configure FUNCTION -background MidnightBlue
th_Misc_paint_add %T CONFIG { -[A-Za-z]} {-[A-Za-z0-9_]+} -foreground orange
th_Misc_paint_add %T CONFIG { --} {-[A-Za-z0-9_]+} -foreground orange
th_Misc_paint_add %T STRING {"[^"]*"} {} -foreground yellow
th_Misc_paint_add %T STRING {'[^']*'} {} -foreground yellow
th_Misc_paint_add %T KEYWORD {(^|[^A-Za-z0-9_])(return|case|switch|if|while|for|foreach|do|else|elseif|goto)($|[^A-Za-z0-9_])} {[A-Za-z0-9_]+} -foreground red
th_Misc_paint_add %T INCLUDE {(^|[^A-Za-z0-9_])source .*} {} -foreground cyan
th_Misc_paint_add %T VARIABLE {\$\(?\{?[A-Za-z0-9_]*\}?\)?} {} -foreground green
th_Misc_paint_add %T COMMENT {#.*} {} -foreground wheat
%T tag raise sel


bind %T <Control-N> {th_Text_goto %W [th_proc_next %W insert]}
bind %T <Control-P> {th_Text_goto %W [th_proc_prev %W insert]}
foreach th_binding {<Control-J> <Double-Meta-1>} {
 bind %T $th_binding {th_Text_select_group %W th_proc_begin th_proc_end}}
foreach th_binding {<Control-j> <Meta-Button-1>} {
 bind %T $th_binding {th_Text_select_group %W th_tclcomment_begin th_tclcomment_end}}
bind %T <Meta-j> {th_tclcomment_format %W [th_tclcomment_begin %W insert] [th_tclcomment_end %W insert]}



th_add_menucode %T {
%M_mb.mb_browse.m.goto add cascade -l Procedure -u 0 -m %M_mb.mb_browse.m.goto.procedure
menu %M_mb.mb_browse.m.goto.procedure
%M_mb.mb_browse.m.goto.procedure add command -l {Next} -u 0 -acc {<Control-N>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_proc_next %M insert]}}
%M_mb.mb_browse.m.goto.procedure add command -l {Previous} -u 0 -acc {<Control-P>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_proc_prev %M insert]}}
%M_mb.mb_browse.m.select add command -l {Procedure} -u 0 -acc {<Control-J>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_proc_begin th_proc_end}}
%M_mb.mb_browse.m.select add command -l {Comment} -u 0 -acc {<Control-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_tclcomment_begin th_tclcomment_end}}
%M_mb.mb_edit.m add command -l {Format Comment} -u 0 -acc {<Meta-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_tclcomment_format %M [th_tclcomment_begin %M insert] [th_tclcomment_end %M insert]}}


}}
set TH(Module,Code,cth) {
th_Misc_paren_add %T {/*} {*/} 0
th_Misc_paren_add %T {#if} {#endif}
set TH(Paint,Hook,%T) {th_Text_tag_regions %T FUNCTION th_fn_begin th_fn_end th_fn_next $start $end ; th_Text_tag_regions %T COMMENT th_ccomment_begin th_ccomment_end th_ccomment_next $start $end}
%T tag configure FUNCTION -background MidnightBlue
th_Misc_paint_add %T TYPE {(^|[\{\(\,;])[ 	]*[A-Za-z0-9_]+\** +(\**|&)[A-Za-z]} {[A-Za-z0-9_]+} -foreground green
th_Misc_paint_add %T TYPE {\([A-Za-z0-9_]+ *\*?\) *[A-Za-z(]} {[0-9A-Za-z_]+} -foreground green
th_Misc_paint_add %T TYPE {(^|[^A-Za-z0-9_])[A-Za-z0-9_]+::} {[0-9A-Za-z_]+} -foreground green
th_Misc_paint_add %T KEYWORD {(^|[^A-Za-z0-9])(return|case|default|switch|if|while|for|do|else|goto|new|delete)($|[^A-Za-z0-9])} {[A-Za-z0-9_]+} -foreground red
th_Misc_paint_add %T STRING {"[^"]*"} {} -foreground yellow
th_Misc_paint_add %T STRING {'(.|\\.|\\[0-9]*)'} {} -foreground yellow
th_Misc_paint_add %T MACRO #.* {} -foreground cyan
%T tag configure COMMENT -foreground wheat
%T tag raise sel


bind %T <Control-N> {th_Text_goto %W [th_fn_next %W insert]}
bind %T <Control-P> {th_Text_goto %W [th_fn_prev %W insert]}
foreach th_binding {<Control-J> <Double-Meta-1>} {
 bind %T $th_binding {th_Text_select_group %W th_fn_begin th_fn_end}}
foreach th_binding {<Control-j> <Meta-Button-1>} {
 bind %T $th_binding {th_Text_select_group %W th_ccomment_begin th_ccomment_end}}
bind %T <Meta-j> {th_ccomment_format %W [th_ccomment_begin %W insert] [th_ccomment_end %W insert]}



th_add_menucode %T {
%M_mb.mb_browse.m.goto add cascade -l Function -u 0 -m %M_mb.mb_browse.m.goto.function
menu %M_mb.mb_browse.m.goto.function
%M_mb.mb_browse.m.goto.function add command -l {Next} -u 0 -acc {<Control-N>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_fn_next %M insert]}}
%M_mb.mb_browse.m.goto.function add command -l {Previous} -u 0 -acc {<Control-P>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_fn_prev %M insert]}}
%M_mb.mb_browse.m.select add command -l {Function} -u 0 -acc {<Control-J>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_fn_begin th_fn_end}}
%M_mb.mb_browse.m.select add command -l {C Comment} -u 2 -acc {<Control-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_ccomment_begin th_ccomment_end}}
%M_mb.mb_edit.m add command -l {Format C Comment} -u 0 -acc {<Meta-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_ccomment_format %M [th_ccomment_begin %M insert] [th_ccomment_end %M insert]}}


}}
set TH(Module,Code,lispth) {
set TH(Paint,Hook,%T) {th_Text_tag_regions %T FUNCTION th_defun_begin th_defun_end th_defun_next $start $end}
%T tag configure FUNCTION -background MidnightBlue
th_Misc_paint_add %T STRING {"[^"]*"} {} -foreground yellow
th_Misc_paint_add %T STRING {'(.|\\.|\\[0-9]*)'} {} -foreground yellow
th_Misc_paint_add %T ATOM {'[A-Za-z\*0-9_-]*} {} -foreground orange
th_Misc_paint_add %T KEYWORD {[^A-Za-z0-9](if|else|when|unless|cond|do|dotimes|dolist)[^A-Za-z0-9]} {[A-Za-z0-9_]+} -foreground red
th_Misc_paint_add %T INCLUDE {\((require|load) .*\)} {} -foreground cyan
th_Misc_paint_add %T COMMENT {;.*} {} -foreground wheat
%T tag raise sel


bind %T <Control-N> {th_Text_goto %W [th_defun_next %W insert]}
bind %T <Control-P> {th_Text_goto %W [th_defun_prev %W insert]}
foreach th_binding {<Control-J> <Double-Meta-1>} {
 bind %T $th_binding {th_Text_select_group %W th_defun_begin th_defun_end}}
foreach th_binding {<Control-j> <Meta-Button-1>} {
 bind %T $th_binding {th_Text_select_group %W th_lispcomment_begin th_lispcomment_end}}
bind %T <Meta-j> {th_lispcomment_format %W [th_lispcomment_begin %W insert] [th_lispcomment_end %W insert]}



th_add_menucode %T {
%M_mb.mb_browse.m.goto add cascade -l Defun -u 0 -m %M_mb.mb_browse.m.goto.defun
menu %M_mb.mb_browse.m.goto.defun
%M_mb.mb_browse.m.goto.defun add command -l {Next} -u 0 -acc {<Control-N>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_defun_next %M insert]}}
%M_mb.mb_browse.m.goto.defun add command -l {Previous} -u 0 -acc {<Control-P>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_defun_prev %M insert]}}
%M_mb.mb_browse.m.select add command -l {Defun} -u 0 -acc {<Control-J>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_defun_begin th_defun_end}}
%M_mb.mb_browse.m.select add command -l {Lisp Comment} -u 5 -acc {<Control-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_lispcomment_begin th_lispcomment_end}}
%M_mb.mb_edit.m add command -l {Format Lisp Comment} -u 0 -acc {<Meta-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_lispcomment_format %M [th_lispcomment_begin %M insert] [th_lispcomment_end %M insert]}}


}}
set TH(Module,Code,htmlth) {
th_Misc_paren_add %T {<} {>} 0
set TH(Paint,Hook,%T) {th_Text_tag_regions %T ANCHOR th_anchor_begin th_anchor_end th_anchor_next $start $end}
%T tag configure ANCHOR -foreground yellow
th_Misc_paint_add %T MARKUP {<[A-Za-z0-9/]*>} {} -foreground wheat
th_Misc_paint_add %T HEADING {<[Hh][1-6]>.*</[Hh][1-6]>} {} -foreground green
th_Misc_paint_add %T IMAGE {<[AaIi][^>]*\.(gif|jpg|jpeg|mpeg|mpg|au|avi|tar)"[^>]*>} {} -foreground red
th_Misc_paint_add %T FORM {<[^>]*\?[^>]*>} {} -foreground orange
th_Misc_paint_add %T CHAR {&[A-Za-z0-9]*;} {} -foreground cyan
%T tag raise sel


bind %T <Control-N> {th_Text_goto %W [th_markup_next %W insert]}
bind %T <Control-P> {th_Text_goto %W [th_markup_prev %W insert]}
foreach th_binding {<Control-j> <Meta-Button-1>} {
 bind %T $th_binding {th_Text_select_group %W th_markup_begin th_markup_end markup}}
foreach th_binding {<Control-J> <Double-Meta-1>} {
 bind %T $th_binding {th_Text_select_group %W th_anchor_begin th_anchor_end anchor}}



th_add_menucode %T {
%M_mb.mb_browse.m.goto add cascade -l Markup -u 0 -m %M_mb.mb_browse.m.goto.markup
menu %M_mb.mb_browse.m.goto.markup
%M_mb.mb_browse.m.goto.markup add command -l {Next} -u 0 -acc {<Control-N>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_markup_next %M insert]}}
%M_mb.mb_browse.m.goto.markup add command -l {Previous} -u 0 -acc {<Control-P>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_markup_prev %M insert]}}
%M_mb.mb_browse.m.select add command -l {Markup} -u 0 -acc {<Control-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_markup_begin th_markup_end markup}}
%M_mb.mb_browse.m.select add command -l {Anchor} -u 0 -acc {<Control-J>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_anchor_begin th_anchor_end anchor}}


}}
set TH(Module,Code,msgth) {
set TH(Paint,Hook,%T) {th_Text_tag_msgs %T $start $end}
th_Misc_paint_add %T QUOTATION {^[|>].*} {} -foreground wheat
%T tag configure HEADER -font 7x13
th_Misc_paint_add %T ADDRESS {([(<, 	`'"]|^)[A-Za-z][-A-Za-z0-9%._+]*@[-A-Za-z0-9]+\.[-A-Za-z0-9]} {[-A-Za-z0-9%._+]*@[-A-Za-z0-9.]*} -underline 1
th_Misc_paint_add %T URL {(http|ftp|file|telnet|news|mailto|gohper)://[-A-Za-z0-9./?@%~]*} {} -relief raised -borderwidth 2
th_Misc_paint_add %T TO {^[>|]? *(Apparently-)?(To|TO|to|CC|Cc|cc):.*} {} -foreground yellow -font [option get %T font Font]
th_Misc_paint_add %T FROM {^[>|]? *From:.*} {} -foreground cyan -font [option get %T font Font]
th_Misc_paint_add %T DATE {^[>|]? *Date:.*} {} -foreground red -font [option get %T font Font]
th_Misc_paint_add %T SUBJECT {^[>|]? *Subj(ect)?:.*} {} -foreground green -font [option get %T font Font]
%T tag raise sel


foreach th_binding {<Control-J> <Double-Meta-1>} {
 bind %T $th_binding {th_Text_select_group %W th_body_begin th_body_end}}
foreach th_binding {<Control-j> <Meta-Button-1>} {
 bind %T $th_binding {if {![th_Text_msg_select_address %W insert]} {bell}}}
bind %T <Control-N> {th_Text_goto %W [th_body_next %W insert]}
bind %T <Control-P> {th_Text_goto %W [th_body_prev %W insert]}



th_add_menucode %T {
%M_mb.mb_browse.m.select add command -l {Body} -u 0 -acc {<Control-J>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_select_group %M th_body_begin th_body_end}}
%M_mb.mb_browse.m.select add command -l {Address} -u 0 -acc {<Control-j>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  if {![th_Text_msg_select_address %M insert]} {bell}}}
%M_mb.mb_browse.m.goto add cascade -l Body -u 0 -m %M_mb.mb_browse.m.goto.body
menu %M_mb.mb_browse.m.goto.body
%M_mb.mb_browse.m.goto.body add command -l {Next} -u 0 -acc {<Control-N>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_body_next %M insert]}}
%M_mb.mb_browse.m.goto.body add command -l {Previous} -u 0 -acc {<Control-P>} -co {if {![winfo exists %M]} {destroy %M_mb} else {
  th_Text_goto %M [th_body_prev %M insert]}}


}}
