#
# Module for browsing around in Entry widgets
#


# where is an index of characters, starting from 0. Puts cursor at $where,
# and makes cursor visible. If dont_stay is 1, and insert is already at the
# right place, beep.
proc th_Entry_goto {w where {dont_stay 1}} {
  if {[catch {$w index $where} i]} {bell ; return 0}
  if {$dont_stay && ($i == [$w index insert])} {bell ; return 0}
  $w icursor $where
  tkEntrySeeInsert $w
  return 1
}


# Selects from cursor to end.
proc th_Entry_select_next_line {w} {
  if {[$w selection present] &&
      (([$w index sel.first] < [$w index insert]) ||
       ([$w index sel.last] > [$w index insert]))} {
    $w selection range sel.first end
  } else {$w selection range insert end}
}

# Select a range of text.
proc th_Entry_select_range {w start end} { 
  set s [$w index $start]
  set e [$w index $end]
  set i [$w index insert]
  if {$s > $e} {bell ; return}
  if {$i == $s} {    $w select from $e ; $w select to $s
  } else {  $w select from $s ; $w select to $e
}}


# Exchanges cursor with mark.
proc th_Entry_exchange_mark {w} {
  if {[catch "$w index anchor" m]} {bell ; return}
  $w select from insert
  th_Entry_goto $w $m
}
