#
# Module for managing grids in Entry widgets
#

# Called by a Entry widget to tell w what to view
proc th_Entry_xview {w t x1 x2} {$t xview [$w index @0]}


# Turns on or off the horizontal grid on w. Side indicates where to put it.
proc th_Entry_toggle_grid_x {w {side bottom}} {
  if {[winfo manager $w] != "pack"} {
    set tl "[set w].gridx"
    set g "[set tl].g"
  } else {
    set tl ""
    set g "[set w]_gridx"}

  global TH
  if {[winfo exists $g]} {
# turn grid off
    set TH(Grid_X,$w) 0

# Reset w's scrollcommand to its scrollbar or nothing if it didn't have one.
    if {[scan [$g cget -xscrollcommand] "%s set" sc] >= 0} {
      $w configure -xscrollcommand "$sc set"
    } else {$w configure -xscrollcommand {}}
    if {$tl != ""} {destroy $tl} else {destroy $g}
  } else {
    set TH(Grid_X,$w) 1
# turn grid on
    if {$tl != ""} {
      toplevel $tl
      wm protocol $tl WM_DELETE_WINDOW { }
      wm transient $tl [winfo toplevel $w]
    }
    entry $g -relief ridge -font [$w cget -font] \
	-width [$w cget -width] -borderwidth 2
    if {$tl != ""} {pack $g -expand yes -fill x
    } else {
      set w_side [lindex [pack info $w] end]
      eval pack $g -anchor n [lrange [pack info $w] 6 15] -expand 0 -side $side -before $w
      switch [list $w_side $side] {
        {top bottom} - {left right} - {bottom top} - {right left} {
          pack $g -after $w -side $w_side
      }}

      set fill [lindex [pack info $w] 7]
      if {$fill == "both"} {pack $g -fill x
      } elseif {$fill == "y"} {pack $g -fill none}}

# Disable scanning on g.
    foreach binding {<Button-2> <B2-Motion>} {bind $g $binding {# do nothing}}

# Fill g with column numbers
    set width [string length [$w get]] ; incr width -1
    $g delete 0 end
    for {set column 0} {$column <= $width} {incr column} {
      if {[expr $column % 10] == 0} {
        $g insert end $column
        incr column [expr [string length $column] - 1]
      } elseif {[expr $column % 5] == 0} {$g insert end "+"
      } else {$g insert end "-"}}
    $g configure -state disabled

# Tie w's scrollcommand over to g.
    $g xview [$w index @0]
    if {[scan [$w cget -xscrollcommand] "%s set" sc] >= 0} {
# Give g the responsibility of moving w's scrollbar.
      $g configure -xscrollcommand "$sc set"
    }
    $w configure -xscrollcommand "th_Entry_xview $w $g"
}}
