#
# Code for history and keyhistory hypertools
#


# Some useful routines to get or set text in widgets
# Geared towards entries, but they will often work with other widgets.

# Gets the contents of widget w.
proc th_Misc_get {w} {
  global auto_index
  if {([info procs th_[winfo class $w]_get] != "") || \
     ([lsearch [array names auto_index] th_[winfo class $w]_get] >= 0)} {
    return [th_[winfo class $w]_get $w]
  } else {return [$w get]}
}

# Sets the contents of widget w to s
proc th_Misc_set {w s} {
  global auto_index
  if {([info procs th_[winfo class $w]_replace] != "") || \
     ([lsearch [array names auto_index] th_[winfo class $w]_replace] >= 0)} {
    th_[winfo class $w]_replace $w $s
  } else {
    $w delete 0 end
    $w insert 0 $s
  }
  return $s
}


# Adds string s to w's history list
proc th_history_add {w s} {
  global TH
  if {[catch "set TH(History,$w)"]} {set TH(History,$w) ""}
  if {[catch "set TH(History,Limit,$w)"]} {set TH(History,Limit,$w) -1}

  set result 0
  if {[set i [lsearch -exact $TH(History,$w) $s]] >= 0} {
    set TH(History,$w) [lreplace $TH(History,$w) $i $i]
    set result 1
  }
  if {[llength $TH(History,$w)] == $TH(History,Limit,$w)} {
    set TH(History,$w) [lreplace $TH(History,$w) 0 0]
  }
  lappend TH(History,$w) $s
  set TH(History,Event,$w) [llength $TH(History,$w)]

  return $result
}


# Menu histories
# These are menus that reflect the history of an entry widget.

# Returns w's history menu, destroys menu if w is gone.
proc th_history_menu {w} {
  global TH
  if {[catch "set TH(History,Menu,$w)"]} {set TH(History,Menu,$w) ""}
  if {$TH(History,Menu,$w) == ""} {return ""}

  set m [winfo parent $TH(History,Menu,$w)]
  set b $m ; append b "button"
  if {![winfo exists $w]} {
	catch "destroy $b"
	catch "destroy $m"
	return ""
  } else {return $TH(History,Menu,$w)
}}

# Adds new entry to w's history menu, labeled label. When invoked, it replaces
# w's contents with string. String defaults to w's current contents, label
# defaults to string.
proc th_history_menu_add {w {string ""} {label ""}} {
  global TH
  if {$string == ""} {set string [th_Misc_get $w]}
  if {$label == ""} {set label $string}
  set result [th_history_add $w $string]

  if {[catch "set TH(History,Limit,$w)"]} {set TH(History,Limit,$w) -1}
  if {[set m [th_history_menu $w]] == ""} {return $result}

  catch {$m delete $label}
  $m add command -label $label -command "th_Misc_set $w \{$string\} ; set TH(History,Event,$w) \[expr \[$m index \{$label\}\] - 1\]"
  if {[expr [$m index last] - [$m cget -tearoff]] == $TH(History,Limit,$w)} {
    $m delete [$m cget -tearoff]
  }
  return $result
}

# Given widget w, creates a history menu & button. If l is given, it is a label
# that should be replaced with the menu.
proc th_history_menu_create {w {l ""}} {
  global TH
  set default_menu_name "(History)"
  if {[winfo exists $l]} {
    if {[catch {set title [$l cget -text]}]} {
      set title $default_menu_name
    }
    set mb $l
    set pack_info [pack info $l]
    set pack_list [pack slaves [winfo parent $l]]
    set i [lsearch $pack_list $l] ; incr i
    if {$i == [llength $pack_list]} {set pack_before ""
    } else {set pack_before [lindex $pack_list $i]}

    destroy $l
    menubutton $mb -text $title
    eval pack $mb $pack_info
    if {$pack_before != ""} {pack $mb -before $pack_before}
  } else {
    set mb [winfo parent $w].thistory
    menubutton $mb -text $default_menu_name
    pack $mb -side left -before $w
  }

  set m "$mb.m"
  set TH(History,Menu,$w) $m

  menu $m
  $mb configure -menu $m
  set b $mb ; append b "button"
  if {[winfo exists $b]} {destroy $b}
  button $b -text "+" -command "th_history_menu_add $w"
  pack $b -side left -before $mb
}


# Keeps track of a 'current' event. Returns event offset from current one,
# making offset event current.
proc th_history_traverse {w {inc 1}} {
  global TH
  if {[catch "set TH(History,$w)"]} {set TH(History,$w) ""}
  if {[catch "set TH(History,Event,$w)"]} {set TH(History,Event,$w) [llength $TH(History,$w)]}
  incr TH(History,Event,$w) $inc
  if {$TH(History,Event,$w) < -1} {set TH(History,Event,$w) -1 ; return ""}
  if {$TH(History,Event,$w) > [llength $TH(History,$w)]} {
    set TH(History,Event,$w) [llength $TH(History,$w)] ; return ""}
  return [lindex $TH(History,$w) $TH(History,Event,$w)]
}

