#
# Bindings for Completh
#


set Bindings(Completion) {
  {Complete_Word 	{th_[winfo class %W]_complete_multiple %W [th_completions %W]}}
  {Show_Completions 	{th_[winfo class %W]_completion_dialog %W}}
}

# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Complete_Word Show_Completions}


set TH_Bindings_Help {
Completion Functions

The bindings here are very simple. Pressing Escape in a widget will attempt to
complete the text immediately before the cursor. For most routines, the program
will beep if no completion is possible or ambiguous completions exist. For
others, the program will still beep if no completion is possible, but if
multiple completions are possible, each one is brought up in turn. When more
than one completion is possible, then one can press Control-Escape to see the
possible completions. This is presented as a dialog window with a listbox, so 
so you can select a completion to use, or none at all. To select a completion
and exit, double-click on the completion, or select the completion, and hit the
'OK' button or <Return> key. You can select a completion by the usual methods
for listboxes, or by pressing 1 to select the 1st entry, 2 for the second, and
so on, or press 0 to deselect all entries.

Complete String:	Escape
Possible Completions:	Control-Escape
}
