#
# Bindings for Filebrowseth
#

set Bindings(File,Browse) {
  {Forward_File 	{th_confirm_save %W {th_file_move %W 1}}}
  {Backward_File 	{th_confirm_save %W {th_file_move %W -1}}}
  {Down_File 		{th_confirm_save %W {th_file_down %W}}}
  {Up_File	  	{th_confirm_save %W {th_file_up %W}}}
}

# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Forward_File Backward_File Up_File Down_File}


set TH_Bindings_Help {
File Browsing Functions

This module implements some simple functions to browse the file and directory
hierarchy. Relative to the current file (the one being viewed by the widget),
one can move one level 'up', by pressing Meta-P. This lists the contents of the
file's directory. You can traverse up the directory hierarchy by pressing
Meta-P repeatedly. Similarly, Meta-N moves down the directory hierarchy. To
view a file or directory inside the directory being viewed, move the text
cursor over to the line with the file to view, and then press Meta-N.Finally,
Meta-F and Meta-B move forward and backward in the directory listing. This way,
you can quickly scan the contents of every file in the directory.

		Meta-
		  P
File: Browse:	B + F
		  N
}
