#  Bindings for Htmlth 


set Bindings(Html) {
  {Next_Markup		{th_Text_goto %W [th_markup_next %W insert]}}
  {Prev_Markup		{th_Text_goto %W [th_markup_prev %W insert]}}
  {Select_Markup	{th_Text_select_group %W th_markup_begin th_markup_end markup}}
  {Select_Anchor	{th_Text_select_group %W th_anchor_begin th_anchor_end anchor}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Next_Markup Prev_Markup Select_Markup Select_Anchor}


set TH_Bindings_Help {
HTML Functions

This module introduces some HTML concepts to a text widget containing HTML. It
adds two concepts: markups and anchors. One can traverse between markups with
Control-N and Control-P. Control-N puts the cursor at the beginning of the next
markup, and Control-P puts the cursor at the beginning of the previous markup
(or current one if it is not already there). One can select the current markup
with Control-j, or by holding down the Meta key and clicking Button 1. And, one
can select the current anchor with Control-J, or by holding down Meta and
double-clicking Button 1.

				Control-
Markup:		Traversal:	 P - N		Meta-
		Select:		   j		       B1
Anchor: 	Select: 	   J		Double-B1
}
