#  Bindings for msgth


set Bindings(Msg) {
  {Select_Body		{th_Text_select_group %W th_body_begin th_body_end}}
  {Select_Address	{if {![th_Text_msg_select_address %W insert]} {bell}}}
  {Next_Body		{th_Text_goto %W [th_body_next %W insert]}}
  {Prev_Body		{th_Text_goto %W [th_body_prev %W insert]}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Select_Body Select_Address Next_Body Prev_Body}


set TH_Bindings_Help {
Message Functions

This module's main function is to format messages sent by various mail/news
readers. It also provides a handful of keyboard functions. One can traverse
between message bodies (skipping the headers) with Control-N and Control-P.
Control-N puts the cursor at the beginning of the next body, and Control-P puts
the cursor at the beginning of the previous body (or current one if it is not
already there). One can select the current address or URL with Control-j. Or
press the Meta key and click Button 1. And, one can select the entire message
body (without headers) with Control-J, or by holding down the Meta key and
double-clicking Button 1.

This module is different from other optional modules in that it requires the
text to be painted before the traversal and select keys will work.

				Control-
Body:		Traversal:	 P - N		Meta-
		Select:		   j		       B1
Address: 	Select: 	   J		Double-B1
}
