#
# Bindings for Multh
#


set Bindings(Mult) {
  {Switch_Buffer 	{th_switch_buffer %W}}
  {All_Shown	 	{th_focus_all %W}}
  {All_Windows 	 	{th_focus_all %W 1}}
  {Move_Below_Last      {th_move_last %W}}
  {Move_Right_Last      {th_move_last %W 1}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Switch_Buffer All_Shown All_Windows
			Move_Below_Last Move_Right_Last}


set TH_Bindings_Help {
Multiple Widget Functions

This module implements some simple functions to work with multiple widgets.
(which will usually be text widgets, although canvases or listboxes may be
possible, too) They generally asuume each such widget is in its own toplevel
window, and some mechanism exists for creating and destroying these widgets, so
there can be any number of these widgets active at a time. Without loss of
generality, let's assume we are dealing with text widgets:

You can, of course, focus between text widgets using Meta-n and Meta-p, as
focuth supplies those bindings. You can also switch between a text widget other
non-text widgets using Tk's Tab bindings. And you can specify a text widget to
focus to using Meta-V, just enter the window title of the toplevel window with
the text widget to focus to.

There is also one window command to move one window below another. Using this
command several times, you can stack multiple windows nicely together on your
screen. The Meta-Control-m key puts the current window immediately below
another shown window (if there is one).

Move below: 	Meta-Control-m
Focus: Window: 	Meta-V

Finally, multh also provides a function to send keybindings to all widgets that
currently have the Tk focus. (Remember that for every toplevel window, Tk
remembers which widget has the focus; and when X focuses on a toplevel window,
Tk focuses on that widget in the toplevel window). So you can send a keybinding
to all the windows, or, instead, all the windows that are not iconified. (Keep
in mind that each window may have a different function associated to a key, for
example, sending Control-A might go to the beginning of a procedure, paragraph,
or HTML anchor, depending on what is displayed in the window.) There are two
bindings to this 'all' function: Meta-/, which elects to send the next key to
all windows that are not currently iconified, and Meta-? which sends the next
key to all windows. When Meta-/ or Meta-? is pressed, an entry marked "All" is
pressed to indicate the next key is going to many windows. Once the key is
pressed, the 'all' mode terminates.

All:		Meta-?
	Shown:	Meta-/

Pressing Meta-/ while already in 'All' mode causes 'All' mode to become
permanent, in which case every keybinding is sent to each window, until the
next occurrence of Meta-/. Some example sequences are: "Meta-? Meta-s" saves
every window's contents (using fileth), "Meta-/ Meta-<" goes to the beginning
of each window's contents (using browseth), "Meta-/ Meta-I" iconifies each
deiconified window (using windowth), "Meta-/ Meta-/ C-s foo" brings up the next
instance of "foo" in every shown window (using searcheth), and "Meta-? Meta-q"
causes each window to quit, which probably means exiting the program.

During All mode the cursor will stay in the All entry, however the old focus
will be remembered, and keybindings will be sent to the old focus, as well as
any other windows involved. If the cursor should fall out of the All entry, then
keys will not execute in all windows, however, pressing Tab will bring the
cursor back into the All entry and things should work properly.

You can have more than one window in All mode, however any keybinding executed
in All mode destroys All mode for each window except the one the keybinding
originated in.
}