#
# Bindings for Painth
#


set Bindings(Paint) {
  {Update_Page 		{th_busy %W th_Text_paint_region %W @0,0 @0,[winfo height %W]}}
  {Update_All		{th_busy %W th_Text_paint_region %W 1.0 end}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Update_Page Update_All}


set TH_Bindings_Help {
Paint Functions

This module introduces the concept of painting certain words (regular
expressions, actually) in text widgets. It adds some simple painting rules,
such as: color all occurrences of the word 'set' green, color all #include
lines blue, etc. This coloring can take a few seconds, so it is not painted
unless explicitly instructed by the user. It also does not maintain the
coloring when editing. So, two simple commands to update the painting are
provided. Pressing Control-U updates all the paint on the visible page, and
pressing Meta-U updates all the paint in the text widget.

Update: Page: 	Control-U
	All: 	Meta-U

This program has a very rudimentary mechanism for adding new regexps to paint.
The process generally goes like this: you test a regular expression (and maybe
a subexpression, too) on a text widget to see what pieces of text conform to
that regexp. You refine the regular expression and test again... Eventually you
come to one you like, and declare that that regular expression should be
painted along with all the others that get painted.

To use this facility, you need to be able to execute wish commands to act on
the text widget. (This can be done with commandeth's wish-command feature, or a
remote program such as rmth.) To test a regular expression in a text widget,
use the following command:
	th_Text_test_paint <regexp> <subexp>
For example, to highlight numbers, you can do:
	th_Text_test_paint {[0-9]+}

You can omit subexp, in which case, regexp is used by itself. You can also imit
the regexp, too, in which case the program highlights all occurrences of the
selection, treating it as a word. The painting algorithm searches for all
occurrences of regexp in the text widget. Within each find, it searches for
subexp. It highlights every subexp with a TEST tag so you can see the effects
of painting that expression. You can clean up the text window and forget the
test by the command:
	th_Text_test_clear

If you have a successful test to use, you must then specify a name to be
associated with this expression, as well as a tag configuration, showing how
the expressions should look whenever you repaint the widget. You do this by
calling the command:
	th_Text_test_use <name> <config> <config>...
For example, after testing for numbers, you can color all numbers blue by
doing:
	th_Text_test_use NUMBER -foreground blue
From now on, whever you repaint a page or the entire widget, all numbers will
turn blue.

This procedure will not actually paint your text. If you'd like your text
painted as well, you can use either:
	th_Text_test_use_page <name> <config> <config>...
to paint the current page, or:
	th_Text_test_use_all <name> <config> <config>...
to paint all the text.

You can always delete 'paint' tags from expression. Issuing the command:
	th_Text_unpaint_this
will remove paint on all regular expressions that are highlighting the text
at the cursor. To unpaint text somewhere other than the cursor, use:
	th_Text_unpaint_this <location>
And to remove every paint available, use:
	th_Text_unpaint_all
}
