#
# Bindings for Parenth
#


set Bindings(Paren) {
  {Check_Exp 		{th_Misc_exp_check %W}}
  {Check_Exp_Self	{th_Misc_exp_check_self %W %A}}
  {Goto_Exp_Left 	{th_[winfo class %W]_goto %W [th_Misc_left_exp %W]}}
  {Goto_Exp_Right 	{th_[winfo class %W]_goto %W [th_Misc_right_exp %W]}}
  {Select_Exp 	 	{th_Misc_select_exp %W}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Goto_Exp_Left Goto_Exp_Right Select_Exp Check_Exp
	Check_Exp_Self}


set TH_Bindings_Help {
Paren Functions

These functions help you balance expressions like parentheses and quotes. (We
will refer to these pairs as parens.) When you hit a close paren (that is, a
closed parentheses, or a quote, or some kind of ending edlimiter like */ for a
C comment), the program automagically checks for the existance of a matching
open paren, usually ignoring any intermediate close/open paren pairs
in-between. The program will point out the matching open paren, or flash a
message if none exists. It also can check to see if a lone open or close paren
exists of a different type. For example, the sequence "([)]" has matching open
and close brackets and parentheses, but they interlock, which is usually not
the desired effect (for example, it is not good C syntax). The program will
warn you of situations like this. You can also check for an open paren without
inserting any text by pressing Meta-' ' (space) after a close paren.

You can select the paren expression next to the cursor with Meta-Shift-space.
Meta-a moves to the beginning of the expression just before the cursor, and
Meta-e moves to the end of the expression, just after the cursor; if the cursor
is not next to an expression, these keys have no effect.

				 Meta-
Expression:	Traversal:	 a - e
		Check: 		   ' '
		Select:		 S-' '
}
