#  Bindings for Tclth 


set Bindings(Tcl) {
  {Next_Tcl_Fn		{th_Text_goto %W [th_proc_next %W insert]}}
  {Prev_Tcl_Fn		{th_Text_goto %W [th_proc_prev %W insert]}}
  {Select_Tcl_Fn	{th_Text_select_group %W th_proc_begin th_proc_end}}
  {Select_Tcl_Comment 	{th_Text_select_group %W th_tclcomment_begin th_tclcomment_end}}
  {Reformat_Tcl_Comment	{th_tclcomment_format %W [th_tclcomment_begin %W insert] [th_tclcomment_end %W insert]}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Next_Tcl_Fn Prev_Tcl_Fn Select_Tcl_Fn Select_Tcl_Comment
	Reformat_Tcl_Comment}


set TH_Bindings_Help {
Tcl Functions

This module introduces the concept of procedures and comments in the Tcl coding
style to text widgets. This is useful, not only for Tcl scripts, but also for
Perl scripts, and to a limited degree, shell scripts and makefiles. It adds
some simple editing and browsing commands for procedures and comments. One can
traverse between procedures with Control-N and Control-P. Control-N puts the
cursor at the beginning of the next procedure, and Control-P puts the cursor at
the beginning of the previous procedure (or current one if it is not already
there). One can select the current comment with Control-j, or pressing Meta
while clicking Button-1. And one can select the current procedure with
Control-J, or pressing Meta while double-clicking Button-1.

There is one editing feature for comments. Meta-j can be used to reformat the
comment containing the cursor, so that every line in the comment is as long as
the widget's width, but not longer.

				Control-
Procedure:	Traversal:	 P - N		Meta-
		Select:		   J		Double-B1
Comment: 	Select: 	   j		       B1
		Reformat:  	Meta-j
}
