#
# Code to generate the frame used to hold entries, messages, etc.
#

set TH_Change_Help {
  Frame

This option allows you to state where the new frame gets placed when you enter
some operation that requires a frame for a widget. After selecting this option,
click anywhere in a remote application, and the frame (or toplevel) widget
containing the one you clicked in will be shown in the "Default Frame" label.
From then on, any widgets that get taught operations requiring frames will place
them in that widget, no matter which hypertool teaches them.

Alternatively you can click outside any Tk application, in which case the
"Default Frame" label will turn blank. In this case, a frame will be created
below any taught widget and it will hold all auxiliary widgets for that widget.
}

source "[file dirname [info script]]/../util/teach_bind.tcl"

if {[info globals Frame_Loaded] == ""} {
set Frame_Loaded 1


# Help text.
set TH_Frame_Help $TH_Teach_Bind_Help ; append TH_Frame_Help {

New frames for entries and messages don't become visible until they are needed.
This program tries to pack it right underneath the widget it applies to. You can
move it somewhere else using packeth. One frame gets created for every widget
that needs one, and doesn't have one specified. So, for example if you choose to
teach all Text widgets, if you specify a frame, every Text widget will use that
frame; and if you don't specify a frame, every Text widget will create a frame
underneath itself when it becomes needed.}


proc teach_binding_code {binding} {
  global All_Bindings App
  if {[catch "send \{$App\} set TH(Binding,$binding)"]} {
    do_cmd_set TH(Binding,$binding) [lindex $All_Bindings($binding) 0]
}}

proc teach_menuentry_code {binding} {
  global All_Bindings App
  if {[catch "send \{$App\} set TH(Menuentry,$binding)"]} {
    set menus [lindex $All_Bindings($binding) 1]
    set l [llength $menus] ; incr l -1
    set menuentry [lindex $menus $l]
    do_cmd_set TH(Menuentry,$binding) $menuentry
}}

# Gives app all the code necessary to create a frame.
proc teach_frame_code {} {
  global App Widget Aux_Frame_App Aux_Frame Widget
  include_files {frame.tcl th_show_entry}

  if {[string match "*_fm.*" $Widget]} {return [send $App winfo parent \[winfo parent $Widget\]]}
  if {![catch {send $App set TH(Frame,$Widget)} result]} {return $result}
  if {($Aux_Frame_App == $App) && ($Aux_Frame != "")} {
    do_cmd_set TH(Frame,$Widget) $Aux_Frame ; return $Aux_Frame}

  if {[send $App winfo manager $Widget] == "pack"} {
    set f $Widget ; append f "_fm"
    if {![send $App winfo exists $f]} {
      do_cmd "pack \[frame $f\] -fill x [pack_side_parms $Widget bottom "send \{$App\}"]\n" 0
  }} else {
      set f [underscore_widget $Widget "send $App"] ; append f "_fm"
      do_cmd_set TH(Frame,$Widget) $f
      if {![send $App winfo exists $f]} {
        do_cmd "pack \[frame $f\] -fill x -side bottom \n" 0
  }}

  foreach binding {OK Cancel} {teach_binding_code $binding}
  return $f
}

# For a widget, returns the appropriate bindings. (Calls widget_frame_bindings
# and adds keys to manipulate the entries.)
proc widget_frame_bindings {bindings} {
  return [lappend bindings [list Cancel [list th_cancel_all %W]]]
}

proc get_frame_widget {} {
  get_widget
  global Widget Class App Aux_Frame Aux_Frame_App
  set Aux_Frame_App $App
  if {[lsearch "Frame Toplevel {}" $Class] < 0} {
    set Aux_Frame [send $App winfo parent $Widget]
  } else {set Aux_Frame $Widget
}}

if {![catch {frame .aux.f}]} {pack .aux.f -side left -expand yes -fill x
  pack [label .aux.f.l -text "Default Frame:"] -side left
  pack [label .aux.f.e -textvariable Aux_Frame -width 0 -relief sunken] \
		-side left -expand no
  set Aux_Frame "" ; set Aux_Frame_App "" ; set App ""
  .buttons.change.m add command -label "Frame" -command {get_frame_widget}
}}
