#
# Standard module for teaching codebindings. (Most hypertools will use this
# some will use other models.
#

source "[file dirname [info script]]/../util/bind.tcl"

if {[info globals Teach_Bind_Loaded] == ""} {
set Teach_Bind_Loaded 1

# Help text.
set TH_Teach_Bind_Help "" ; append TH_Teach_Bind_Help {
The Teach Menu

Select an entry in this menu, and then click on a remote widget. This hypertool
will then teach its code to the widget, and give it access depending on the menu
option selected. The menu options are as follows:

  Widget Keybindings

This option endows the widget you teach with the keybindings necessary to
execute the functions taught it. No other widgets are affected.

  Class Keybindings

This option endows the class of the widget you teach with the keybindings
necessary to execute the functions taught it. So you essentially teach all the
widgets of that particular class to execute your functions when certain keys are
pressed over them.

  Menus

This option creates a menu above the widget that allows you to execute the
functions provided. The menu will only affect the widget taught.

You can teach both keybindings and menus to a widget. When you teach a widget
menus, if it already received the corresponding keybindings, it adds those as
accelerators on the menu entries whose functions match the keybindings. This
serves as a handy key 'reference chart'.

  Code

This lets you teach the code necessary for this hypertool's functions to work No
bindings or menus are created. This option is implicitly done whenever you
select either of the other options.

} $TH_Bind_Help


# Teach an app our bindings
proc teach_codebindings {b class_flag} {
  if {![get_widget]} {bell ; return}
  global Menu_Flag ; set Menu_Flag $b ; incr Menu_Flag -1
  if {[set bindings [widget_bindings]] == ""} {bell ; return}
  clear_output
  teach_code
  switch $b {
    1 {if $class_flag {global Class ; teach_keybindings $Class $bindings
         } else {global Widget ; teach_keybindings $Widget $bindings
    }} 2 {teach_menubindings $bindings
  }}
  return
}


set menu .buttons.teach.m
$menu add command -label "Widget Keybindings" -command {teach_codebindings 1 0}
$menu add command -label "Class Keybindings" -command {teach_codebindings 1 1}
$menu add command -label "Menus" -command {teach_codebindings 2 1}
$menu add command -label "Code" -command {teach_codebindings 3 1}
}
