#
# Module for browsing around in Listbox widgets
#


# Where is index of row (starting from 0)
proc th_Listbox_goto {w where {dont_stay 1}} {
  if {[catch {$w index $where} i]} {bell ; return 0}
  if {($i == [$w index active]) && $dont_stay} {bell ; return 0}
  $w activate $i
  $w see $i
  return 1
}


# Select items from start to end in listbox.
proc th_Listbox_select_range {w start end} { 
  if {[lsearch "Multiple Extended" [$w cget -selectmode]] >= 0} {
    $w selection set $start $end
  } elseif {[$w selection includes $start]} {
    $w selection clear $start $end ; $w selection set $end
  } else {$w selection clear $start $end ; $w selection set $start
}}

# Selects all items between top visible item and anchor.
proc th_Listbox_select_region {w} {
  if {[catch {set m [$w index anchor]}]} {bell ; return}
  if {[catch {set i [$w index active]}]} {bell ; return}
  if {$m < $i} {
    th_Listbox_select_range $w $m $i
  } else {th_Listbox_select_range $w $i $m
}}


# Exchanges mark with top visible item.
proc th_Listbox_exchange_mark {w} {
  if {[catch {set m [$w index anchor]}]} {bell ; return}
  $w selection anchor active
  th_Listbox_goto $w $m
}
