#
# Module for file I/O for Entry widgets
#

# Writes contents of s out to descriptor f.
proc th_string_write_file {s f} { puts $f $s }

proc th_Entry_write_file {w f} { th_string_write_file [$w get] $f }

proc th_Entry_contents {w} {return [$w get]}

# Returns contents of file descriptor f.
proc th_string_read_file {f} {return [read -nonewline $f]}

proc th_Entry_read_file {w f {gradual 0}} {
  $w delete 0 end
  $w insert 0 [th_string_read_file $f]
  $w icursor 0
  $w xview 0
}

# Inserts contents of f at insert in s.
proc th_string_insert_file {s f insert} {
  set text [read -nonewline $f]
  set i [$w index insert]
  return "[string range $s 0 [expr $insert - 1]]$text[string range $s $insert end]"
}

# Inserts contents of f at insert in w.
proc th_Entry_insert_file {w f {gradual 0}} {
  set text [read -nonewline $f]
  set i [$w index insert]
  global auto_index
  if {([info procs th_Entry_register_undoable_cmd] != "") || \
     ([lsearch [array names auto_index] th_Entry_register_undoable_cmd] >= 0)} {
    th_Entry_register_undoable_cmd $w "Insert $text"}
  $w insert insert $text
  $w icursor $i
  $w xview [expr $i - 1]
}

# Maintains the insert and view at the same points while executing cmd.
proc th_Entry_save_view {w cmd} {
  set view [$w index @0]
  set insert [$w index insert]
  eval $cmd
  $w xview moveto 0 ; $w xview scroll $view units
  $w icursor $insert
}
