#
# Operations for msg manipulation in Text widgets.
#


proc th_body_begin {w index} {
  set r [$w tag ranges HEADER]
  set n [$w tag nextrange HEADER $index]
  set i [lsearch $r [lindex $n 0]] ; incr i -1
  if {([lsearch [$w tag names "$index-1c"] HEADER] >= 0)} {
    incr i -2
    if {$n == ""} {return [lindex $r [expr [llength $r] - 3]]}
  }
  if {$n == ""} {return [lindex $r end]
  } elseif {$i < 0} {return ""
  } else {return [lindex $r $i]
}}

proc th_body_end {w index} {
  set r [$w tag ranges HEADER]
  if {[set n [$w tag nextrange HEADER $index]] == ""} {return "end -1c"}
  if {[$w compare [lindex $n 0] == $index]} {
    if {[set n [$w tag nextrange HEADER "$index +1c"]] == ""} {return "end -1c"}}

  set i [lsearch $r [lindex $n 0]]
  return "[lindex $r $i] -1c"
}

proc th_body_next {w index} {
  set r [$w tag ranges HEADER]
  set n [$w tag nextrange HEADER $index]
  set i [lsearch $r [lindex $n 0]] ; incr i
  if {([lsearch [$w tag names $index] HEADER] >= 0) &&
	([lsearch $r [$w index $index]] < 0)} {
    incr i -2
    if {$n == ""} {return [lindex $r end]}
  }
  if {$n == ""} {return ""
  } else {return [lindex $r $i]
}}

proc th_body_prev {w index} {
  if {[set begin [th_body_begin $w $index]] == ""} {return ""}
  if {[$w compare $begin != $index]} {
    return $begin
  } else {return [th_body_begin $w "$index -1c"]
}}


# Called after usual paint commands for some small adjustments.
proc th_Text_tag_msgs {w {start 1.0} {end end}} {
  set prev_end ""
  for {set range [$w tag nextrange TO 1.0]} {$range != ""} \
	{set range [$w tag nextrange TO "[lindex $range 1] +1c"]} {
    set s [th_para_begin $w [lindex $range 0]]
    set e [th_para_end $w $s]
    for {set l $s} {[$w compare $l < $e]} {set l [$w index "$l + 1l"]} {
      set line [$w get $l "$l lineend"]
      if {([string first ":" $line] < 0) &&
	([lindex [$w tag names "$l -1l"] end] == "TO")} {
        $w tag add TO $l "$l +1l"
      }
      if {([llength [$w tag names $l]] > 0)} {
        $w tag add [lindex [$w tag names $l] 0] "$l lineend"
    }}
    $w tag add HEADER $s "$e linestart"
    if {$prev_end != ""} {$w tag remove HEADER "$prev_end +1c" "$s -1c"}
    set prev_end $e
  }
  if {$prev_end != ""} {$w tag remove HEADER "$prev_end +1c" end}
}

proc th_Text_msg_select_address {w index} {
  set tags [$w tag names $index]
  foreach tag {URL ADDRESS} {
    if {[lsearch $tags $tag] >= 0} {
      set r [$w tag ranges $tag]
      if {[set n [$w tag nextrange $tag $index]] == ""} {
        set i [llength $r]} else {set i [lsearch $r [lindex $n 0]]}
      th_Text_select_range $w [lindex $r [expr $i - 2]] [lindex $r [expr $i -1]]
      return 1
  }}
  return 0
}
