#
# Bindings for Browseth
#

set Bindings(Browse) {
  {Goto_Mark 		{th_[winfo class %W]_exchange_mark %W}}
  {Goto 		{th_goto %W}}
}
set Bindings(Browse,Select) {
  {Select_Clear 	{selection clear -displayof %W}}
  {Select_Copy 		{if {[selection own -displayof %W] == "%W"} {
	    clipboard clear -displayof %W
	    clipboard append -displayof %W -- [selection get -displayof %W]}}}
}
set Bindings(Browse,Scroll,X) {
  {Scroll_Line_Left 	{th_scroll %W xview scroll -1 units}}
  {Scroll_Line_Right	{th_scroll %W xview scroll  1 units}}
  {Scroll_Page_Left 	{th_scroll %W xview scroll -1 pages}}
  {Scroll_Page_Right 	{th_scroll %W xview scroll  1 pages}}
}
set Bindings(Browse,Scroll,Y) {
  {Scroll_Line_Begin 	{th_scroll %W yview scroll -1 units}}
  {Scroll_Line_End	{th_scroll %W yview scroll  1 units}}
  {Scroll_Page_Begin 	{th_scroll %W yview scroll -1 pages}}
  {Scroll_Page_End 	{th_scroll %W yview scroll  1 pages}}
}
set Bindings(Browse,Scrollregion) {
  {Goto_Screen_Left 	{th_scroll %W xview moveto 0}}
  {Goto_Screen_Right 	{th_scroll %W xview moveto 1}}
  {Goto_Screen_Up 	{th_scroll %W yview moveto 0}}
  {Goto_Screen_Down 	{th_scroll %W yview moveto 1}}
  {Center_Cursor 	{catch {th_Canvas_make_cursor_visible %W [%W focus]}}}
}
set Bindings(Browse,Text) {
  {Center_Cursor 	{th_Text_center_cursor %W}}
  {Goto_Char_Left  	{th_Text_goto %W {insert -1c}}}
  {Goto_Char_Right 	{th_Text_goto %W {insert +1c}}}
  {Goto_Char_Up 	{th_Text_goto %W [tkTextUpDownLine %W -1]}}
  {Goto_Char_Down	{th_Text_goto %W [tkTextUpDownLine %W  1]}}
  {Goto_Char_PUp        {th_Text_goto %W [th_Text_adjacent_line %W -1]}}
  {Goto_Char_PDown      {th_Text_goto %W [th_Text_adjacent_line %W +1]}}
  {Goto_Word_Left 	{th_Text_goto %W {insert -1c wordstart}}}
  {Goto_Word_Right	{th_Text_goto %W {insert wordend}}}
  {Goto_Screen_Left 	{th_Text_goto %W "@0,[lindex [%W bbox insert] 1]"}}
  {Goto_Screen_Right 	{th_Text_goto %W "@[winfo width %W],[lindex [%W bbox insert] 1]"}}
  {Goto_Screen_Up	{th_Text_goto %W @0,0}}
  {Goto_Screen_Down 	{th_Text_goto %W "@[winfo width %W],[winfo height %W]"}}
  {Goto_Edge_Begin 	{th_Text_goto %W "insert linestart"}}
  {Goto_Edge_End 	{th_Text_goto %W "insert lineend"}}
  {Goto_Edge_Top        {th_Text_goto %W 1.0}}
  {Goto_Edge_Bottom     {th_Text_goto %W end}}
  {Center_Screen 	{th_Text_goto %W "@[expr [winfo width %W] / 2],[expr [winfo height %W] / 2]"}}
  {Select_Line 		{th_Text_select_next_line %W}}
  {Select_Region 	{th_Text_select_to %W insert}}
  {Select_All 		{%W tag add sel 1.0 end}}
  {Mark  		{%W mark set anchor insert}}
}
set Bindings(Browse,Entry) {
  {Center_Cursor 	{th_scroll %W xview [expr [%W index insert] - (([%W index "@[winfo width %W]"] - [%W index @0]) / 2)]}}
  {Goto_Char_Left 	{th_Entry_goto %W [expr [%W index insert] - 1]}}
  {Goto_Char_Right 	{th_Entry_goto %W [expr [%W index insert] + 1]}}
  {Goto_Word_Left 	{th_Entry_goto %W [string wordstart [%W get] [expr [%W index insert] -1]]}}
  {Goto_Word_Right 	{th_Entry_goto %W [string wordend [%W get] [%W index insert]]}}
  {Goto_Screen_Left 	{th_Entry_goto %W @0}}
  {Goto_Screen_Right 	{th_Entry_goto %W "@[winfo width %W]"}}
  {Goto_Edge_Begin 	{th_Entry_goto %W 0}}
  {Goto_Edge_End 	{th_Entry_goto %W end}}
  {Center_Screen 	{th_Entry_goto %W "@[expr [winfo width %W] / 2]"}}
  {Select_Line 		{th_Entry_select_next_line %W}}
  {Select_Region 	{%W selection to insert}}
  {Select_All 		{%W selection range 0 end}}
  {Mark 		{%W selection from [%W index insert]}}
}
set Bindings(Browse,Canvas) {
  {Goto_Char_Left 	{catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] - 1]}}}
  {Goto_Char_Right 	{catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] + 1]}}}
  {Goto_Word_Left 	{catch {th_Canvas_goto %W [string wordstart [%W itemcget [%W focus] -text] [expr [%W index [%W focus] insert] -1]]}}}
  {Goto_Word_Right 	{catch {th_Canvas_goto %W [string wordend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]]}}}
  {Goto_Edge_Begin 	{th_Canvas_goto %W 0}}
  {Goto_Edge_End 	{th_Canvas_goto %W end}}
  {Select_Line 		{th_Canvas_select_next_line %W [%W focus]}}
  {Select_Region 	{th_Canvas_select_region %W [%W focus]}}
  {Select_All 		{catch {%W select from [%W focus] 0 ; %W select to [%W focus] end}}}
  {Mark 		{catch {set TH(Mark,%W,[%W focus]) [%W index [%W focus] insert]}}}
}
set Bindings(Browse,Listbox) {
  {Goto_Edge_Begin 	{th_scroll %W xview moveto 0}}
  {Goto_Edge_End 	{th_scroll %W xview moveto 1}}
  {Goto_Edge_Top 	{th_Listbox_goto %W 0}}
  {Goto_Edge_Bottom 	{th_Listbox_goto %W end}}
  {Center_Cursor 	{%W xview moveto 0 ; th_scroll %W yview [expr [%W index active] - ([%W index "@0,[winfo height %W]"] - [%W index "@0,0"]) / 2]}}
  {Goto_Char_Up 	{th_Listbox_goto %W [expr [%W index active] - 1]}}
  {Goto_Char_Down	{th_Listbox_goto %W [expr [%W index active] + 1]}}
  {Center_Screen 	{%W activate "@0,[expr [winfo height %W] / 2]"}}
  {Select_Line  	{if {[selection own -displayof %W] == "%W"} {
	tkListboxBeginSelect %W active} else {tkListboxBeginExtend %W active}
	th_Listbox_goto %W [expr [%W index active] + 1]}}
  {Select_Region	{th_Listbox_select_region %W}}
  {Select_All 		{tkListboxSelectAll %W}}
  {Mark 		{%W selection anchor active}}
}
set Bindings(Browse,Scrollbar) {
  {Goto_Char_Up 	{tkScrollByUnits %W hv -1}}
  {Goto_Char_Down	{tkScrollByUnits %W hv  1}}
  {Scroll_Page_Begin 	{tkScrollByPages %W hv -1}}
  {Scroll_Page_End 	{tkScrollByPages %W hv  1}}
  {Goto_Edge_Begin 	{tkScrollToPos %W 0}}
  {Goto_Edge_End 	{tkScrollToPos %W 1}}
  {Mark 		{set TH(Mark,%W) [lindex [%W get] 0]}}
}
set Bindings(Browse,Scale) {
  {Goto_Char_Up 	{tkScaleIncrement %W up little noRepeat}}
  {Goto_Char_Down	{tkScaleIncrement %W down little noRepeat}}
  {Scroll_Page_Begin 	{tkScaleIncrement %W up big noRepeat}}
  {Scroll_Page_End 	{tkScaleIncrement %W down big noRepeat}}
  {Center_Cursor 	{th_Scale_goto %W [expr ([%W cget -from] + [%W cget -to]) / 2]}}
  {Goto_Edge_Begin 	{th_Scale_goto %W [%W cget -from]}}
  {Goto_Edge_End 	{th_Scale_goto %W [%W cget -to]}}
  {Mark 		{set TH(Mark,%W) [%W get]}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Scroll_Line_Begin Scroll_Line_End Scroll_Line_Left
  Scroll_Line_Right Scroll_Page_Begin Scroll_Page_End Scroll_Page_Left
  Scroll_Page_Right Goto_Char_Left Goto_Char_Right Goto_Char_Up Goto_Char_Down
  Goto_Word_Left Goto_Word_Right Goto_Screen_Left Goto_Screen_Right
  Goto_Screen_Up Goto_Screen_Down Goto_Edge_Begin Goto_Edge_End 
  Center_Cursor Center_Screen Select_Line Select_Region Select_Copy
  Select_All Select_Clear Goto_Mark Mark Goto Goto_Char_PUp Goto_Char_PDown
  Goto_Edge_Top Goto_Edge_Bottom OK Cancel}


set TH_Bindings_Help {
Browsing Functions

These are bindings to control the location of a cursor in the widget, and to
control the scrolling view of the widget, if it can be scrolled, and to control
the selection, if the widget allows selection. We will deal with each of these
items in turn.

Scrolling is allowed on any widget that supports a scrollbar, or that could
support one. Currently, this includes text, entry, listbox, and canvas widgets.
Note that entries can't scroll vertically. Browseth also will allow scrolling on
scale and scrollbar widgets, too. The selection is unaffected. If the widget has
a cursor, it is generally left alone. One can scroll forward, backward, left,
and right, depending on the widget.

One can scroll a widget down one line with Control-z and up one line with
Meta-z. Control-Z scrolls a widget one character to the right and Meta-Z scrolls
a widget one character to the left. Scrollbars are scrolled one unit of the
widget they are controlling, and canvases scroll by 1/10th of their scrolling
dimension.

                    Meta-z
 Scroll: Line: Meta-Z + Control-Z
                   Control-z

Scrolling one screenful, or page is also possible. One can scroll a widget
forward one 'page' with Control-`, and backward one page with Meta-`. Likewise,
Control-~ scrolls to the right one page and Meta-~ scrolls to the left one page.
Scrollbars also have the ability to do page scrolling, in whichever dimension
they reside. A scrollbar's paging function has the same effect as paging the
widget they scroll over. Canvases page by scrolling 9/10ths of their dimension.
Scales can page by changing their value by the contents of their -bigincrement
option (see the scale manpage for more info).

Finally, for Text, Entry, Listbox, and Canvas widgets (the ones that have
'cursors'), one can adjust the view so that the cursor is in the center of the
view, or at least visible, using Control-l. This does not move the cursor, just
the view:

                   Meta-`
Scroll: Page: Meta-~ + Control-~
                  Control-`
Center cursor	Control-l

Gotoing is similar to scrolling, except that instead of changing the view, and
perhaps dragging the cursor along afterwards, one moves the cursor, and maybe
changes the view to keep the cursor visible. While cursors are only available to
text and entry widgets, many other widgets have a 'value' which can act like a
cursor. For example, scales have a numerical value which can be adjusted like a
cursor, and listbox widgets have a 'active entry', which gets underlined, and
can be manipulated like a cursor (though it takes up an entire line on a
listbox).

One can goto one unit left using Control-b, right using Control-f, up using
Control-p, and down using Control-n. This unit is usually a character or line of
text, but it can instead be a scrollbar or scale's increment value.

Entries and text widgets also have the ability to go forward or backward by one
word. Meta-b moves backward one word, and Meta-f moves forward one word.

Text widgets have one more option. Control-p and Control-n move the insert from
the nth character on one line to the nth character on an adjacent line. However,
what with super-long lines, tab stops, variable fonts, and embedded widgets,
this new character may not be even close to the old one. So if you want to move
to the character immediately above or below the one with the insert cursor, use
ta-, or Meta-., respectively. In essence, Control-n/p work on lines of text,
while Meta-,/. work on the layout of your screen.

                 Control-p           Meta-,
Goto: Char: Control-b + Control-f      +
                 Control-n           Meta-.
Goto: Word: Meta-b + Meta-f

For those widgets that support it, you can move the cursor to any edge of the
currently vierable window. Pressing Control-, puts the cursor at the left edge
of the screen and Control-. puts the cursor at the right edge of the screen (on
the current line). And pressing Control-< puts the cursor at the first viewable
character in the widget, while pressing Control-> puts the cursor at the last
viewable character in the widget. (Canvases are an exception to this, the
aforementioned characters move the canvas widget to the left, right, top, or
bottom of its scrollable region.)

                     Control-<
Goto: Screen: Control-, + Control-.
                     Control->

Finally, while the above keys move the cursor to edges in the current view of
the widgets, the following keys move the cursor to edges of the cursor's
available scroll region. (Scrollbar and scale widgets support these bindings as
well). One moves to the left of the widget using Control-a and the right with
Control-e, to the top with Meta-< and to the bottom with Meta->.

                    Meta-<
Goto: Edge: Control-a + Control-e
                    Meta->

There are a handful of special goto commands available to some widgets. First of
all, one can move the cursor to the center of the screen with Control-L. This
differs from Control-l in that Control-l moves the view of the widget for the
purpose of making the cursor visible and Control-L moves the cursor to a visible
location without changing the view. One can also set the selection anchor using
Control-' ' (that's a space right there), and then goto that mark using
Control-x. After Control-x goes to the mark, it moves the mark to the old cursor
location, so you can use Control-x to switch between two locations. Widgets that
don't support selection, like scrollbars and scales can still use these
commands.

Mark:	Set:	Control-space
Goto:	Center:	Control-L
	Mark:	Control-x

Finally, one can enter an index to goto using Meta-g. This brings up an entry,
into which you type an index to go to, and the cursor is placed at that index.
In the entry, you can press Return to go to the index currently entered, or
Control-g to forget about going to an index. The syntax of the index varies with
the widget, see the manpages on the widgets for details, but here's a quick
overview:

The index of Scale widgets is the scale value. For scrollbar widgets, it is a
number between 0 and 1, where 0 represents the top/left and 1 represents the
bottom/right ends of the scrollbar. For listbox widgets, 0 is the topmost item,
1 the next, etc. and end is the last item. For entries, 0 is the leftmost
character, 1 the next, etc. and end is the last item. For texts, 1.0 is the
first character on the first line, 1.1 is the 2nd character on the first line,
2.5 is the 6th character on the 2nd line, end is the last character. For text
widgets, you can just enter 1 for the first line, 2 for the second, or you can
enter a valid text index.

Goto:	Specify:	Meta-g
	Execute:	Return (or Control-m)
	Abort:		Control-g

There are four options offered for selection. One can use Control-K to select a
line of text. Pressing Control-K multiple times selects more lines after the
cursor. This can be used in the same fashion for listboxes and entries and
canvases, although in a more limited fashion. One can also select a region by
setting the anchor somewhere (with Control-space) and putting the cursor at the
other end of the region and press Control-Shift-space. One can also select all
the text with Control-/. One can clear the selection with Control-\. Finally,
one can copy the selected text to the clipboard using Meta-w. This allows you to
paste the text currently selected even if the text gets deselected.

Select	Line 	Control-K
	Region	Control-Shift-space
	All	Control-/
	Clear	Control-\ 
	Copy 	Meta-w
}
