#
# Bindings for Elsbeth
#


# These get taught to all programs
set Bindings(Makebeth,All) {
  {Toggle_Menus 	{th_toggle_menus %W}}
}
set Bindings(Makebeth,Text) {
  {Add_Para_Module 	{th_add_module paragrath %W}}
  {Add_Tcl_Module  	{th_add_module tclth %W}}
  {Add_C_Module  	{th_add_module cth %W}}
  {Add_Lisp_Module  	{th_add_module lispth %W}}
  {Add_HTML_Module  	{th_add_module htmlth %W}}
  {Add_Msg_Module  	{th_add_module msgth %W}}
}


# These get taught only to Elsbeth
set Bindings(Elsbeth) {
  {Show_X 		{elsbeth_goto_file %W X}}
  {Help 		{elsbeth_help %W}}
  {Make 		{elsbeth_make %W}}
  {Visit_File_Prompt 	{elsbeth_visit_file %W}}
  {Visit_File		{elsbeth_visit_file %W insert}}
  {Quit 		{elsbeth_destroy_text %W 0}}
  {Quit_Remember	{elsbeth_destroy_text %W 1}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Visit_File Visit_File_Prompt Help Show_X Make Quit
	Quit_Remember Add_Para_Module Add_Tcl_Module Add_C_Module
	Add_Lisp_Module Add_HTML_Module Add_Msg_Module Toggle_Menus}


set TH_Bindings_Help {
Other TH Functions

Makebeth adds a few functions that are available to all other programs, and
a few functions that are available only to Elsbeth. This section will cover the
functions available to all other programs; the next section will cover Elsbeth
functions.

This toolkit provides many bindings for lots of different types of widgets. It
also allows menus to be created for the widget, where the menus outline every
function available at a keypress. To activate those menus, press Button 3 over
any widget. A menubar will appear over the widget (or at least in the same
window), with all the functions provided in this toolkit. Pressing Button 3 over
the widget makes the menubar disappear again. This menubar is handy for
executing functions, or simply as a reference chart linking functions to
keybindings.
Toggle Menu: 	Button-3

Many of the entry widgets brought up by various functions (search, file, etc)
have specific completion bindings defined. Most entries can complete Tcl
commands, variables, or files, as well as give the results of Tcl commands,
variables, and glob patterns. Generally, the entry will do completion based on
its purpose, for example, the file entry completes a full filename, and the
search entry completes a word in the text. The text window can also complete a
word in itself.

Finally text widgets get a menu called "Modules". This shows some optional
modules that aren't loaded upon startup, but can be added later. The module is
the name of the hypertool that would teach the bindings. For example paragrath
indicates the paragrath hypertool which teaches bindings about paragraph
manipulation.


General Elsbeth Functions

Elsbeth adds a few functions to the functions available in the hypertools.
These functions are very idiosyncratic to Elsbeth, so they wouldn't be very
usable if they were taught to other programs; therefore only Elsbeth may use
them.

Elsbeth provides several specialized commands for bringing up new windows on
files. The most basic one is Meta-Control-v, which visits a file. It prompts
you for a filename, and brings up a window allowing you to edit the file. If
there is already a window open on the file, it brings up the old window,
instead of opening a new one. You can also give it a directory name, in which
case Elsbeth will open up a new window listing the contents of that directory,
or use an old one. Or you can enter a piped command, and Elsbeth will bring up
a new window (or old one) on the command's output. Elsbeth will generally use
old windows only if they contain the same filename, but if you specify a
command, it will use a window containing a command only if: the two commands
have the same name, and only differ by their arguments, and, the command name
has no space between it and the preceding pipeline symbol (|). So an Elsbeth
window containing the output of "|make foo" will get used when you visit "|make
bar", but not when you visit "| make foo". That space there is crucial.

There is also an implicit-visit-file command, which you can execute by pressing
Meta-v. This is a general hypertext feature; it tries to parse the text under
the cursor for a file and a line to visit. If it finds one, it visits the file.
It also looks for a line number after the file; if it finds one, it points the
cursor at that line in the visited file. It can also look for a column number,
if one is specified. You can also invoke this command over any filename in the
text widget by double-clicking over the name while holding down the Control
key. This is a nifty hypertextual feature that allows you to quickly bring up a
line of a file that is referenced by a grep command, or one that contains C
code your compiler doesn't like, or even bring up files and directories up from
directory listings.

File: 	Visit: 		Meta-Control-v
	Visit Implicit:	Meta-v		Control-Double-Button-1

The implicit-visit command has one other semantic meaning. If you are editing a
bunch of files with functions (say, several C files), and the functions are all
painted, you can double-click on a function name, to bring up the file
containing that function. This works in all modes that support the FUNCTION tag
(C, Tcl, Perl, Makefile, Lisp).

There are three more specialized commands that also visit a file, that is, they
open a new window on a file, or find an old one and focus on that. The
Meta-Control-x function brings up a window on the X selection; this is useful
for viewing a file in two separate windows. The Meta-m function provides a
simple 'make' utility, it allows you to view the output of a make command. You
can alter the make command to do something like 'make install' and it will
remember your changes, and bring up a window on your make command. Finally
pressing Meta-Control-h brings up a window on Elsbeth's help file, (which
includes this text).

Visit X:	Meta-Control-x
Make: 		Meta-m
Help: 		Meta-Control-h

You can close a window by pressing Meta-q on a window to quit viewing that
window. Elsbeth quits when all windows are closed. You could also close a
window using Meta-Q, which quits the window, but it also remembers the current
location of the insert cursor and scrollbar, for the next time the file is
visited by Elsbeth.

File:	Quit:		Meta-q
	Quit-Remember:	Meta-Q

Elsbeth also provides several handy file routines not supported by fileth (due
to the nature of Els). First of all, it will complain if you try to edit the
same file in two windows, and you can change the contents of one window, or
close either one. Elsbeth also updates the title and icon name of each window
with the file it is currently viewing.

Also, the file entry widgets have a small completion list of acceptable
commands (for using in command pipelines), that generate useful output. (For
example, when using Elsbeth to view files, you're better off using "|ls -lF"
rather than just "|ls".) This list is stored in the global variable:
TH(Completions,File,Commands), you may wish to add your own commands to this
variable in the .th/elsbeth file.

Elsbeth also extends the marks added by marketh. It remembers all marks made to
a file, and will include those marks the next time you view that file. It does
this by storing all the marks in the file $HOME/.th/elsbeth.info. It also
stores, for each file, the location of the cursor, the current text view, and
any custom paints you might have added.

All information on files is retained in memory while Elsbeth is running. When
the last window is closed, Elsbeth saves the information in a file called
$(HOME)/.th/elsbeth.info. Elsbeth will not save this file if the $(HOME)/.th
directory does not exist.

Occasionally the elsbeth.info file can get large, due to lots of files being
remembered, and thereby bog down Elsbeth. There are a handful of procedures one
can invoke to clean up excess information on files. In the wish command, one
can execute the procedures elsbeth_clear_marks or elsbeth_clear_locations. Or
just elsbeth_clear, which clears both. (These only erase information for files
not currently being viewed by Elsbeth.) Finally, one can browse Elsbeth
information with the elsbeth_info_visit procedure, which brings up a list of
all files Elsbeth has info on. You can select a file to visit it, or you can
select 'OK' to visit none.

The extra loadable modules mentioned in the previous section also sometimes
get loaded automatically during startup. To give the newest window the
paragraph bindings, for instance, one could issue the command:
elsbeth -c "th_add_module paragrath" ...
(The -c option is interpreted by els to execute the following Tcl command.)

Some modules may be loaded automatically upon startup due to the file name. For
example, the paragrath module will be added automatically on any filename with
the ending ".txt". The modules are described below:

These modules may paint some of your text. If you don't like the colors they
use, you can specify alternate colors for the tags in your .elsbeth file. For
example, if you'd rather C strings were colored red instead of yellow (the
defualt), you should have your .th/elsbeth file contain this:

	set code [info body elsbeth_new_text]
	proc elsbeth_new_text {tl} [concat $code { ; 
	
	  $tl.t tag configure STRING -foreground red
	}]
}
