#
# Bindings for Searcheth
#

set Bindings(Search) {
  {Search_Forward 	{th_Misc_search %W forward string}}
  {Search_Backward 	{th_Misc_search %W backward string}}
  {Search_Forward_Regexp {th_Misc_search %W forward regexp}}
  {Search_Backward_Regexp {th_Misc_search %W backward regexp}}
  {Toggle_Incremental_Search {th_toggle_incremental_search %W}}
}
set Bindings(Search,Case) {
  {Toggle_Case_Sensitivity {th_checkbutton_variable Search,Case,%W}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Search_Forward Search_Backward Search_Forward_Regexp
    Search_Backward_Regexp Toggle_Case_Sensitivity Toggle_Incremental_Search
    OK Cancel}


set TH_Bindings_Help {
Search Functions

These functions allow you to perform searches for strings or regular
expressions, in text, listbox, canvas, or entry widgets. It provides an
incremental search option, as well as case sensitivity on or off, and can search
forward or backward through the text, starting from the cursor.

To search forward for a string, hit Control-s. Control-r is similar, except it
searches backwards for a string. For regular expressions, use Control-S and
Control-R instead.

	Forward        Reverse
String: Control-s      Control-r
Regexp: Control-S      Control-R

Once the search entry is open, you can enter a search string (or  regular
expression). To actually execute the search while in the entry, press Control-s
(or Control-r to search backward). You can continue searching forward or
backward as many times as you want. If a search fails, trying another search in
the same direction will start from the beginning of the text (or the end for
reverse searching). You can quit searching using Return or Control-g.

Search:	Again:	Forward:	Control-s
		Reverse:	Control-r
	Exit:			Return    Control-g

Searching may be case-sensitive, depending on what model of search case you are
using. If you are using an implicit model, then searches are by default
case-insensitive. The only times a search will be case-sensitive is if the
replace window is open, or if the search string contains an uppercase letter.
So, if you want case-insensitive searching, keep your search string lowercase,
otherwise case will be sensitive. The other model is explicit case-awareness,
in which you explicitly turn on and off case-sensitivity. You do this by
pressing Meta-Control-c.

Normally a search doesn't occur until you press Control-s or Control-r in the
search entry. However, you can make searching incremental by pressing Meta-C
during a search. Henceforth, every character you type in the entry widget will
perpetuate a search. This is useful for entering search strings correctly.

Toggle Case Sensitivity:   Meta-Control-c	(only avail. for explicit model)
Toggle Incremental Search: Meta-C

For text and listbox widgets, there is a highlight function. In a text widget,
any text that was matched to the search string gets highlighted, but only after
it's been the search tag. If you press Meta-Control-l in the search entry, then
all future matches (in the direction you are searching) get highlighted. All
matches stay highlighted until you exit the search feature. For listboxes, any
fuuture matches get selected.
Highlight Searches: 	   Meta-Control-l

For text widgets there are two extra functions, named Mark and Unmark. They are
Control-M, which adds a mark tag to the text found, and Meta-M, which removes a
mark tag from the text found. These are basically the same functions provided
by the marketh hypertool, but you can use them in the search entry on text
found in the text widget. See the marketh help section for more details on
marks.

Mark: 			Control-M
Unmark: 		Meta-M

If you are using the replace features, then two more functions are added to the
search entry. They are Control-c and Control-C, and both serve to set up the
replace facility. They do this by adding a 'replace' entry, in which you specify
the string to change to. Use Control-C to use the same replacement string as
during the last replace, and use Control-c to start with a fresh replacement
entry. The replace entry takes the same bindings as the search entry, but
Control-c and Control-C are different. In the replace entry, pressing Control-c
changes the currently found match of the search string with the replacement
string (if there is a match), and finds the next occurrence of the search
string. You can alternate Control-c and Control-s to change or skip successive
search strings. Finally, you can use Control-C to replace every future
occurrence of the search string with the replacement string. Control-C also
closes the replacement features, as do Control-g and Return.

Replace: One: 		   Control-c
Replace: All:		   Control-C
}
