#
# Bindings for Windowth
#


set Bindings(Window) {
  {Shrink_X 		{th_geometry_adjust [winfo toplevel %W] 0 -%IRX}}
  {Shrink_Y 		{th_geometry_adjust [winfo toplevel %W] 1 -%IRY}}
  {Expand_X 		{th_geometry_adjust [winfo toplevel %W] 0 +%IRX}}
  {Expand_Y 		{th_geometry_adjust [winfo toplevel %W] 1 +%IRY}}
  {Iconify_Window	{th_iconify_window %W}}
  {Raise_Window 	{th_raise_window %W}}
  {Move_Right 		{th_geometry_adjust [winfo toplevel %W] 2 +%IMX}}
  {Move_Left 		{th_geometry_adjust [winfo toplevel %W] 2 -%IMX}}
  {Move_Up 		{th_geometry_adjust [winfo toplevel %W] 3 -%IMY}}
  {Move_Down 		{th_geometry_adjust [winfo toplevel %W] 3 +%IMY}}
  {Move_Edge_Left	{th_geometry_change [winfo toplevel %W] 2 0}}
  {Move_Edge_Top	{th_geometry_change [winfo toplevel %W] 3 0}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Shrink_X Shrink_Y Expand_X Expand_Y
		Move_Right Move_Left Move_Up Move_Down
		Iconify_Window Raise_Window Move_Edge_Left Move_Edge_Top
}


set TH_Bindings_Help "" ; append TH_Bindings_Help {
Window Functions

One resizes the window by enlarging or shrinking it by some number of pixels, or
by characters if the window size is determined by a text or listbox widget.
During this resizing the title bar remains stationary and the bottom or right
edge moves in the specified direction. To shrink the window horizontally, one
uses Control-[, to expand it one uses Control-} "\{" {. To shrink the window
vertically, one uses Control-], to expand it, one uses Control-} "\}" {.

One can think of the functionality by what each key does to the lower right
corner:

           Control-
              [
Resize:     ] + } "\}" {
              } "\{" {

One can also move the window in any direction. Here the window size remains
constant. Meta-[ moves the window up one line, Meta-} "\{" { down one line, Meta-]
right one char, and Meta-} "\}" { left one char.

            Meta-
              [
Move:       ] + } "\}" {
              } "\{" {

Finally, one has the option of placing the window at the top or the left of the
screen. Control-Meta-[ moves the window to the top edge, and Control-Meta-]
moves it to the left edge.

        Control-Meta-
              [
To Edge:    ] +

This is rather complicated. A simpler way of using these bindings, is to
consider the following semantics table:

Control-	=Resize		=Shrink (up/left)	-Open	=rows
Meta-		=Move	-Shift-	=Expand (down/right)	-Closed	=columns
Control-Meta	=To Edge

Two other commands are provided. Meta-I iconifies the current window. and Meta-i
raises the window, deiconifying it if necessary.

Window:	Iconify:Meta-I
	Raise:	Meta-i
}
