#
# File to help extend & stylize the widgets used by the hypertools
#


proc update_arguments {var value} {
  global Arg_Count argc argv 
  if {[catch "set Arg_Count"]} {set Arg_Count 0}
  if {$argc > $Arg_Count} {uplevel #0 set $var \{[lindex $argv $Arg_Count]\}
  } elseif {$value != "var"} { uplevel #0 set $var \{$value\} }
  incr Arg_Count
  if {[catch "uplevel #0 set $var"]} {uplevel #0 set $var \{\}}
  return [uplevel #0 set $var]
}

# Creates an entry. The entry lives in frame w, also created. A historyth menu
# is given, named 'prompt:', and the entry is tied to variable var, and set
# with initial value value. If value is var, it is set to the current value of
# var. (got that?)
proc create_form_entry {w prompt var {value var}} {
  set val [update_arguments $var $value]
  frame $w
  eval pack $w -f x -expand no
  uplevel #0 entry $w.e -textvariable $var
  pack $w.e -fill x -expand yes -s right
  th_history_menu_create $w.e
  $w.thistory configure -text "$prompt:"
  if {$val != ""} {th_history_menu_add $w.e $val}
}


# Creates a scale, named w, with text prompt, and tied to variable var, and set
# with initial value value. Args are additional arguments to give to the scale.
# (such as -from 10 -to 20)
proc create_form_scale {w prompt var {value var} args} {
  set val [update_arguments $var $value]
  scale $w -label $prompt -command "set $var" -orient horizontal
  eval $w configure $args
  pack $w -s top -expand no -f x
  $w set $val
}

# Creates a checkbutton, named w, with text prompt, and tied to variable var,
# and set with initial value value, packed on side side.
proc create_form_checkbutton {w prompt var {value var} {side top}} {
  set val [update_arguments $var $value]
  checkbutton $w -text $prompt -variable $var
  pack $w -f x -expand yes -f x -s $side
}

# Create a forms menu button & menu & add args.
proc create_form_menu {name args} {
  set w [string tolower $name]
  menubutton .buttons.$w -menu .buttons.$w.m -text $name
  pack .buttons.$w -side right -before .buttons.bind_mb
  menu .buttons.$w.m
  eval add_to_form_menu "$name" $args
}

# Add some options (args) to a form menu
proc add_to_form_menu {name args} {
  set w [string tolower $name]
  set i [.buttons.$w.m index last]
  global Menu Menu_List
  foreach item $args {
    incr i
    .buttons.$w.m add checkbutton -label [lindex $item 0] -variable Menu($w,$i)
    set Menu_List($w,$i) [lindex $item 1]
    set Menu($w,$i) 1
}}

# Returns the text of every item selected in the form menu (in reverse order)
proc form_menu_selected {name} {
  global Menu Menu_List
  set result ""
  set w [string tolower $name]
  for {set i [.buttons.$w.m index last]} {$i > 0} {incr i -1} {
    if $Menu($w,$i) {
      lappend result $Menu_List($w,$i)
  }}
  return $result
}

# Shows the help window, inserting text if necessary.
proc show_help {} {
  wm deiconify .tl ; raise .tl
  if {[.tl.t index end] != "2.0"} {return}

  global Help ; .tl.t insert insert $Help
  set index [string length [.tl.t get 1.0 end]]
  while {[set new_index [string last "\n\n" [.tl.t get 1.0 "1.0 +$index c"]]] >= 0} {
    set i [.tl.t index "1.0 +$new_index c +2 l linestart"]
    if {([.tl.t get "$i +1l linestart"] == "\n")} {
	.tl.t tag add header $i "$i lineend"
    }
    set index $new_index
  }
  .tl.t tag add header 1.0 "1.0 wordend"
  .tl.t configure -state disabled
}

# Create the help window.
if {![catch {toplevel .tl}]} {
  wm withdraw .tl
  text .tl.t -yscrollcommand ".tl.s set" -setgrid true
  scrollbar .tl.s -command ".tl.t yview"

  wm title .tl "Help [wm title .]"
  wm iconname .tl "Help [wm title .]"

  .tl.t tag configure header -underline 1
  
  frame .tl.ok
  pack .tl.ok -f x -s top -anchor e

  button .tl.ok.quit -text "OK" -co "wm withdraw .tl"
  pack .tl.ok.quit -s right -f x -expand yes
  pack .tl.s -side left -fill y
  pack .tl.t -expand yes -fill both
}
