wm title . {System Performance Monitor}
canvas .c -width 300 -height 46 -bd 2 -relief raised \
  -highlightthickness 0
set fg [option get . foreground Foreground]
if \"$fg\"=="" {set fg black}
pack .c
.c create text 40 10 -text Core -anchor e -fill $fg
.c create text 40 25 -text Swap -anchor e -fill $fg
.c create text 40 40 -text CPU -anchor e -fill $fg
.c create line 50 10 60 10 -width 10 -fill red -tags coreUsed
.c create line 60 10 70 10 -width 10 -fill blue -tags coreBuffer
.c create line 70 10 80 10 -width 10 -fill green -tags coreFree
.c create line 50 25 60 25 -width 10 -fill red -tags swapUsed
.c create line 60 25 70 25 -width 10 -fill green -tags swapFree
.c create line 10 40 20 40 -width 10 -fill red -tags usr
.c create line 20 40 30 40 -width 10 -fill yellow -tags nice
.c create line 30 40 40 40 -width 10 -fill blue -tags sys
.c create line 40 40 290 40 -width 10 -fill green -tags idle
set CpuUpdateTime 100
set CpuAveragingWindow 400
set MemUpdateTime 500

bind .c <Double-Button-1> SetupDialog

proc SetupDialog {} {
  global CpuUpdateTime CpuAveragingWindow MemUpdateTime
  toplevel .d
  wm title .d {Performance Monitor Setup}
  frame .d.f
  scale .d.f.s1 -from 100 -to 2000 -length 300 -orient horizontal \
     -label {CPU statistics update interval (ms)} -bd 2 -relief sunken
  .d.f.s1 set $CpuUpdateTime
  pack .d.f.s1 -side top -pady 10 -padx 5
  scale .d.f.s2 -from 100 -to 5000 -length 300 -orient horizontal \
     -label {CPU statistics averaging interval (ms)} -bd 2 -relief sunken
  .d.f.s2 set $CpuAveragingWindow
  pack .d.f.s2 -side top -pady 10 -padx 5
  scale .d.f.s3 -from 250 -to 5000 -length 300 -orient horizontal \
     -label {Memory statistics update interval (ms)} -bd 2 -relief sunken
  .d.f.s3 set $MemUpdateTime
  pack .d.f.s3 -side top -pady 10 -padx 5
  pack .d.f -side top
  button .d.ok -text {OK} -command {
    set CpuUpdateTime [.d.f.s1 get]
    set CpuAveragingWindow [.d.f.s2 get]
    set MemUpdateTime [.d.f.s3 get]
    destroy .d
  }
  pack .d.ok -side right -padx 10 -pady 5
  button .d.cancel -text {Cancel} -command {
    destroy .d
  }
  pack .d.cancel -side right -padx 10 -pady 5
}
