/*
** This file implements a simple ASCII text editor
*/
int main(int argc, char **argv){
  Et_Init(&argc,argv);
  ET_INSTALL_COMMANDS;
  ET_INCLUDE( tkedit.tcl );
  Et_MainLoop();
  return 0;
}

/* Make the window given as the sole argument visible */
ET_PROC( MakeWindowVisible ){
  int x,y,w,h;
  int screen_w, screen_h;
  char *windowName;
  extern int sscanf();

  if( argc!=2 ) return ET_ERROR;
  windowName = argv[1];
  ET(wm deiconify %s(windowName); raise %s(windowName));
  sscanf(ET_STR(wm geometry %s(windowName)),"%dx%d+%d+%d",&w,&h,&x,&y);
  screen_w = ET_INT(winfo screenwidth .);
  screen_h = ET_INT(winfo screenheight .);
  if( x < 0 || x + w > screen_w || y + h > screen_h || y < 0 ){
    ET(wm geometry %s(windowName) +%d((screen_w-w)/2)+%d((screen_h-h)/2));
  }
  return ET_OK;
}

/* The "bell" command in Tk4.0 is busted.  This is a replacement */
ET_PROC( bell ){
  XBell(Et_Display,0);
  return ET_OK;
}
