option add *highlightThickness 0
wm title . tkterm
wm iconname . tkterm

# Functions to tell about this program
#
proc AboutMessage {} {
  catch {destroy .about}
  toplevel .about
  wm title .about "About TkTerm"
  wm iconname .about "AboutTkTerm"
  label .about.title -text {TkTerm}\
    -font -adobe-times-bold-i-normal--24-240-75-75-p-128-iso8859-1
  pack .about.title -side top -pady 15
  message .about.subtitle -width 10c -justify center \
    -font -adobe-times-bold-i-normal-*-14-140-75-75-p-77-iso8859-1 \
    -text "A VT100 terminal emulator based\non the Tcl/Tk Text widget"
  pack .about.subtitle -side top -pady 10 -padx 15
  message .about.msg -width 10c -text "
By D. Richard Hipp
Hipp, Wyrick & Company, Inc.
6200 Maple Cove Lane
Charlotte, NC 28269
704-948-4565
drh@vnet.net" \
    -font -adobe-times-medium-r-normal-*-12-120-75-75-p-64-iso8859-1
  pack .about.msg -padx 15 -anchor w
  button .about.dismiss -text {Dismiss} -command {destroy .about}
  pack .about.dismiss -pady 8
  wm withdraw .about
  update idletasks
  set x [expr [winfo rootx .] + ([winfo width .]-[winfo reqwidth .about])/2]
  set y [expr [winfo rooty .] + ([winfo height .]-[winfo reqheight .about])/2]
  wm geometry .about +$x+$y
  wm deiconify .about
}

# The function key editor
#
proc EditFunctionKeys {} {
  catch {destroy .keyedit}
  toplevel .keyedit
  wm title .keyedit "TkTerm Function Key Bindings"
  wm iconname .keyedit "TkTerm Bindings"
  set f [frame .keyedit.f1 -bd 1 -relief raised]
  pack $f -side bottom -fill x -expand 1
  button $f.b1 -text OK -highlightthickness 0 -command {
    foreach i $MacroNames {
      set Macros($i) [.keyedit.f2.f.e$i.e get]
    }
    SaveMacros
    destroy .keyedit
  }
  button $f.b2 -text Cancel -highlightthickness 0 -command {destroy .keyedit}
  pack $f.b1 $f.b2 -side right -pady 5 -padx 10 -expand 1
  set f [frame .keyedit.f2 -bd 1 -relief raised]
  pack $f -side bottom -fill both -expand 1
  global Macros MacroNames
  CheckMacros
  set f [frame $f.f]
  pack $f -padx 10 -pady 10
  foreach i $MacroNames {
    set e [frame $f.e$i]
    pack $e -side top -fill x -anchor c
    label $e.l -text $i -width 3 -anchor w
    pack $e.l -side left
    entry $e.e -width 30 -bd 2 -relief sunken
    $e.e insert end $Macros($i)
    pack $e.e -side left
    bind $e.e <Return> {tkEntryInsert %W %A}
    bind $e.e <Tab> {tkEntryInsert %W %A; break}
  }
  wm withdraw .keyedit
  update idletasks
  set x [expr [winfo rootx .] + ([winfo width .]-[winfo reqwidth .keyedit])/2]
  set y [expr [winfo rooty .] + ([winfo height .]-[winfo reqheight .keyedit])/2]
  wm geometry .keyedit +$x+$y
  wm deiconify .keyedit
}

##### The following routines are responsible for loading function
# key macros from the .tkterm.macros file, or writing them back.
#
set MacroNames {F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12}
set MacroFile [glob ~]/.tkterm.macros
set MacroModTime 0
proc LoadMacros {} {
  global Macros MacroNames MacroFile MacroModTime
  if [info exists Macros] {unset Macros}
  if {[file readable $MacroFile]} {
    foreach i [exec cat $MacroFile] {
      set tag [lindex $i 0]
      set value [lindex $i 1]
      if {[regexp {F1?[0-9]} $tag]} {
        set Macros($tag) $value
      }
    }
    set MacroModTime [file mtime $MacroFile]
  }
  foreach i $MacroNames {
    if {![info exists Macros($i)]} {set Macros($i) $i}
  }
}
proc SaveMacros {} {
  global Macros MacroNames MacroFile
  set out {}
  foreach i $MacroNames {
    lappend out [list $i $Macros($i)]
  }
  catch {exec echo $out >$MacroFile 2>/dev/null}
}
proc CheckMacros {} {
  global MacroModTime MacroFile
  if {[file readable $MacroFile]} {
    if {[file mtime $MacroFile]>$MacroModTime} {
      LoadMacros
    }
  } else {
    LoadMacros
  }
}

##### Construct the menu bar
#
frame .menubar -bd 2 -relief raised
pack .menubar -side top -fill x

menubutton .menubar.file -text File -menu .menubar.file.m -pady 0
pack .menubar.file -side left -padx 10
menu .menubar.file.m
  .menubar.file.m add command -label {New} \
      -command "Paste \"$cmd_dir/$cmd_name &\n\""
  .menubar.file.m add separator
  .menubar.file.m add command -label {Exit} -command {destroy .}

menubutton .menubar.edit -text Edit -menu .menubar.edit.m -pady 0
pack .menubar.edit -side left -padx 10
menu .menubar.edit.m
  .menubar.edit.m add command -label {Copy} \
     -command EditCopy
  .menubar.edit.m add command -label {Paste} \
     -command EditPaste

menubutton .menubar.options -text Options -menu .menubar.options.m -pady 0
pack .menubar.options -side left -padx 10
menu .menubar.options.m
  .menubar.options.m add cascade -label {Font Size} \
    -menu .menubar.options.m.fontsize
  menu .menubar.options.m.fontsize
  foreach i {Tiny Small Short Normal Large {Very Large} Huge} {
    .menubar.options.m.fontsize add radiobutton -label $i \
       -value $i -variable Font -command "ChangeFont \"$i\""
  }
  .menubar.options.m add cascade -label {Height} \
    -menu .menubar.options.m.height
  menu .menubar.options.m.height
  foreach i {8 12 16 24 30 36 42 48 54 60 72} {
    .menubar.options.m.height add radiobutton -label $i \
       -value $i -variable Height -command "ChangeHeight $i"
  }
  .menubar.options.m add cascade -label {Width} \
    -menu .menubar.options.m.width
  menu .menubar.options.m.width
  foreach i {64 72 80 90 110 123 140 161} {
    .menubar.options.m.width add radiobutton -label $i \
       -value $i -variable Width -command "ChangeWidth $i"
  }
  .menubar.options.m add command -label {Function Keys...} \
    -command EditFunctionKeys

menubutton .menubar.help -text Help -menu .menubar.help.menu -pady 0
pack .menubar.help -side left -padx 5
menu .menubar.help.menu
  .menubar.help.menu add command -label {About This Program} \
     -command AboutMessage

proc EditPaste {} {
  Paste [selection get]
}

# Put a speed bar directly below the menu bar
frame .sbar -bd 1  -relief raised
pack .sbar -side top -expand 1 -fill x
set i 0
foreach btn {
  {Copy EditCopy}
  {Paste EditPaste}
  {{24 Lines} {ChangeHeight 24}}
  {{36 Lines} {ChangeHeight 36}}
  {{48 Lines} {ChangeHeight 48}}
} {
  incr i
  button .sbar.b$i -text [lindex $btn 0] \
    -font -adobe-helvetica-medium-r-normal-*-8-80-75-75-p-46-iso8859-1 \
    -command [lindex $btn 1] \
    -padx 1 -pady 0
  pack .sbar.b$i -side left -padx 1 -pady 1
}

####
# Default window settings
#
set Width 80
set Height 24
set Font Normal

######
# These are all the valid fonts.  FB(x) is the bold font which
# corresponds to F(x).  If there is no FB(x), then no bold text
# will be shown.
#
set F(Tiny) -schumacher-clean-medium-r-normal-*-6-60-75-75-c-40-iso8859-1
set F(Small) -schumacher-clean-medium-r-normal-*-8-80-75-75-c-50-iso8859-1
set F(Short) -schumacher-clean-medium-r-normal-*-10-100-75-75-c-60-iso8859-1
set FB(Short) -schumacher-clean-bold-r-normal-*-10-100-75-75-c-60-iso8859-1
set F(Normal) -misc-fixed-medium-r-semicondensed-*-13-120-75-75-c-60-iso8859-1
set FB(Normal) -misc-fixed-bold-r-semicondensed-*-13-120-75-75-c-60-iso8859-1
set F(Large) -misc-fixed-medium-r-normal-*-14-130-75-75-c-70-iso8859-1
set FB(Large) -misc-fixed-bold-r-normal-*-14-130-75-75-c-70-iso8859-1
set F(Very\ Large) -misc-fixed-medium-r-normal-*-15-140-75-75-c-90-iso8859-1
set FB(Very\ Large) -misc-fixed-bold-r-normal-*-15-140-75-75-c-90-iso8859-1
set F(Huge) -misc-fixed-medium-r-normal-*-20-200-75-75-c-100-iso8859-1

##### Construct the text widget with its scrollbar
#
text .t -bd 1 -relief raised -yscrollcommand {.sb set} \
  -height 24 -width 80 -exportselection 0 \
  -wrap none -padx 2 -pady 2 \
  -font $F($Font) -highlightthickness 0
pack .t -side left -fill both -expand 1
scrollbar .sb -command {.t yview} -orient vertical \
  -highlightthickness 0 -bd 1 -relief raised
pack .sb -side left -fill y

.t tag config ul -underline 1
.t tag config iv -foreground [.t cget -background]
.t tag config iv -background [.t cget -foreground]
if {[info exists FB($Font)]} {
  .t tag config bd -font $FB($Font)
} else {
  .t tag config bd -font $F($Font)
}

# Change the width of the text widget
proc ChangeWidth {newWidth} {
  .t config -width $newWidth
  WindowSizeChangeNotify
  global Width
  set Width $newWidth
}
# Change the height of the text widget
proc ChangeHeight {newHeight} {
  .t config -height $newHeight
  WindowSizeChangeNotify
  global Height
  set Height $newHeight
}
# Change the font of the text widget
proc ChangeFont {newFont} {
  global F FB Font
  .t config -font $F($newFont)
  set Font $newFont
  if {[info exists FB($newFont)]} {
    .t tag config bd -font $FB($newFont) -foreground Black
  } else {
    .t tag config bd -font $F($newFont) -foreground Blue
  }
}

bindtags .t .t
bind .t <KeyPress> {SendToTTY %N}
bind .t <Control-KeyPress> {SendToTTY [expr %N&0x1f]}
bind .t <Control-space> {SendZeroToTTY}
bind .t <Return> {SendToTTY 10}
bind .t <Escape> {SendToTTY 033}
bind .t <BackSpace> {SendToTTY 8}
bind .t <Delete> {SendToTTY 0177}
bind .t <Up> {.t yview scroll -1 pages}
bind .t <Down> {.t yview scroll +1 pages}
bind .t <Prior> {.t yview scroll -1 units}
bind .t <Next> {.t yview scroll +1 units}
bind .t <Home> {.t yview moveto 0}
bind .t <End> {.t yview moveto 1}
foreach i $MacroNames {
  bind .t <$i> "CheckMacros; Paste \$Macros($i)"
}

# Button bindings copied from the default Text widget bindings
#
foreach b {
  1 B1-Motion Double-1 Triple-1 Shift-1 Double-Shift-1
  Triple-Shift-1 B1-Leave B1-Enter ButtonRelease-1 Control-1
} {
  bind .t <$b> [bind Text <$b>]
  bind .t <$b> {+.t mark set insert $CurY.$CurX}
}
focus .t

# A routine for dispensing the selection.  The selection is always owned
# by the window ".".  Its value is stored in the variable "Selection"
#
set Selection {}
selection handle . RetrieveSelection
proc RetrieveSelection {offset max} {
  global Selection
  return [string range $Selection $offset [expr {$offset+$max}]]
}

# This routine is called whenever "." owns the selection but another
# window claims ownership.
#
proc LoseSelection {} {
  global Selection
  set Selection {}
}

# Copy the text selected in the text widget into the Selection variable,
# then claim ownership of the selection.
#
proc EditCopy {} {
  global Selection
  catch {
    set Selection [.t get sel.first sel.last]
    selection own . LoseSelection
  }
}

# The following array holds a correspondance between menu items
# and functions that can be bound to the speed bar
#
set Speedable {
  {File/Quit Quit {destroy .}}
  {Edit/Copy Copy EditCopy}
  {Edit/Paste Paste EditPaste}
  {Options/FontSize/Tiny Tiny {ChangeFont Tiny}}
  {Options/FontSize/Small Small {ChangeFont Small}}
  {Options/FontSize/Short Short {ChangeFont Short}}
  {Options/FontSize/Normal Normal {ChangeFont Normal}}
  {Options/FontSize/Large Large {ChangeFont Large}}
  {Options/FontSize/VeryLarge {Very Large} {ChangeFont {Very Large}}}
  {Options/FontSize/Huge Huge {ChangeFont Huge}}
  {Options/Height/8 8 {ChangeHeight 8}}
  {Options/Height/12 12 {ChangeHeight 12}}
  {Options/Height/16 16 {ChangeHeight 16}}
  {Options/Height/24 24 {ChangeHeight 24}}
  {Options/Height/8 {ChangeHeight 8}}
  {Options/Height/8 {ChangeHeight 8}}
  {Options/Height/8 {ChangeHeight 8}}
  {Options/Height/8 {ChangeHeight 8}}
  {Options/Height/8 {ChangeHeight 8}}
}

########
# The following is for debugging use only.
#
proc Dump {} {
  global Btm CurX CurY ScrollTop ScrollBtm

  return "iBtm=$Btm iCur=$CurY.$CurX iScroll=$ScrollTop-$ScrollBtm end=[.t index end] insert=[.t index insert]"
}
#
########
