# filesel.tcl - file selection box for windows
#
# (C) T. Jaekel, Siemens AG, Berlin (Germany)
# 1/28/96
#
# FileSelectBox with Tcl/Tk for Windows
# This tcl script needs the dynamic extension tcl_ls.dll (!) and
# the tcl/tk version 7.5a2/4.1a2.
#
# With a simple click you can select a file and with a double click you
# select the file or you can change the directory (if it was a directory instead a file).
#
# You can use this tcl file also for UNIX if you guarante that your ls command
# append a '/' character on each directory name or you create a shared library for 
# your unix system of the source tcl_ls.c
#
	
# change the path to shared library extension and the name of the extension file
#for my Windows PC:
#set LS_EXT_DIR e:/tcl/ls_ext
#set LS_EXT_FILE tcl_ls.dll
#for my HPUX workstation:
set LS_EXT_DIR /users/jaekel/TCL_TK_NEW/LS_EXT
set LS_EXT_FILE tcl_ls.sl

set LS_EXT_INIT tcl_ls

#----------------------------------------------------------------------------------------------------------

load "$LS_EXT_DIR/$LS_EXT_FILE" $LS_EXT_INIT

proc insert_dir_content {win dir} {
	$win.frame2.list delete 0 end
	set content [ls $dir]
	set a [split $content \n]
	set j [llength $a]
	for {set i 0} {$i <= $j} {incr i} {
		$win.frame2.list insert end [lindex $a $i]
	}
}

proc fileselectClick {win y} {
	set filename [$win.frame2.list get [$win.frame2.list nearest $y]]
	set f [split $filename /]
	if {$filename != $f} { return }
	$win.frame1.file delete 0 end
	$win.frame1.file insert end $filename
}

proc insertnewDir {win dir} {
	catch "cd $dir" notok
	if {$notok != ""} { bell }
	$win.frame1.file delete 0 end
	$win.frame3.dir delete 0 end
	$win.frame3.dir insert 0 [pwd]
	insert_dir_content $win "."
}

proc fileselectDoubleClick {win y} {
	global sel_filename
	set filename [$win.frame2.list get [$win.frame2.list nearest $y]]
	set f [split $filename /]
	if {$filename == $f} {
		set dir_name [$win.frame3.dir get]
		set sel_filename "$dir_name/$filename"
#		for test purpose remove the comment sign in the next line
		puts stdout $sel_filename
		wm withdraw $win
		return
	}
	insertnewDir $win $filename
}

#
# global variables
#
# the selected filename will be stored in the following variable
set sel_filename ""

proc create_file_select  {} {
	global sel_filename
	set win .filesel
	toplevel $win
	wm title $win "FileSelect"
	wm iconname $win "FileSelect"
	wm geometry $win +100+100
	wm withdraw $win
	wm protocol $win WM_DELETE_WINDOW "wm withdraw $win"

	frame $win.frame1 -relief groove -bd 2
	frame $win.frame2 -relief groove -bd 2
	frame $win.frame3 -relief groove -bd 2

	label $win.frame1.label -text "Filename:"
	entry $win.frame1.file -bg white
	bind $win.frame1.file <Return> {
		set file_name [.filesel.frame1.file get]
		set dir_name [.filesel.frame3.dir get]
		set sel_filename "$dir_name/$file_name"
#		for test purpose remove the comment sign of the next line
		puts stdout $sel_filename
		wm withdraw .filesel
	}

	listbox $win.frame2.list -bg white -yscrollcommand [list $win.frame2.scroll set]
	scrollbar $win.frame2.scroll -command [list $win.frame2.list yview]
	insert_dir_content $win "."
	bind $win.frame2.list <Button-1> "fileselectClick $win %y"
	bind $win.frame2.list <Double-Button-1> "fileselectDoubleClick $win %y"

	label $win.frame3.label -text "Directory:"
	entry $win.frame3.dir -bg white
	$win.frame3.dir insert 0 [pwd]
	bind $win.frame3.dir <Return> {
		set dir [.filesel.frame3.dir get]
		insertnewDir .filesel $dir
	}

	pack $win.frame1 $win.frame2 $win.frame3 -expand yes -fill both
	pack $win.frame1.label $win.frame1.file -side top -fill x
 	pack $win.frame2.list $win.frame2.scroll -side left -fill y
	pack $win.frame3.label $win.frame3.dir -side top -fill x
}

#----------------------------------------------------------------------------------------------------------------
# create a main window with a menu to test the procedure of file selection

wm title . "Select_a_file"
wm iconname . "SelFile"

frame .menubar -relief groove -bd 2
menubutton .menubar.file -text "File" -menu .menubar.file.m -relief raised
menu .menubar.file.m
.menubar.file.m add command -label "Quit" -command "destroy ."
.menubar.file.m add command -label "FileSelect" -command "wm deiconify .filesel"

pack .menubar -side top -fill x
pack .menubar.file -side left

create_file_select

#---- end of file -------
