# [[ Header ]]

# Copyright (c) 1996 by SoftWorks.  All Rights Reserved.
# File:   visual.tcl
# Author: Richard Schwaninger
# Date:   21/02/1996
# System: chiron.standalone
# RCS:    $Id$

# [endfold]

# visual tests
# these can be executed with a standard wish


set simplewish 0

if { ![info exists AppName] } {
   set simplewish 1
} 

if {$simplewish} {
   source font.tcl
} else {
   Require tester 2
   TestLoad font
   Require tk 4.1
}	 

font_Init


set n 0
set font [Font get Helvetica]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n

set font [Font get Times]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n

set font [Font get Terminal]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n
set font [Font get Terminal width=condensed]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n
set font [Font get Terminal width=condensed size=13]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n

set font [Font get Helvetica slant=italic size=16]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n

set font [Font get Helvetica size=18]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n

set font [Font get Helvetica weight=bold]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n


set font [Font get Terminal size=8 weight=bold slant=italic]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n
set font [Font get Times size=24 weight=bold slant=italic]
label .l$n -text "$n: $font\nThe brown fox jumps over the fence" \
      -font $font
pack .l$n -anchor w
incr n


button .exit -text "ENOUGH is ENOUGH" -command exit \
      -font [Font get Helvetica size=24 slant=italic weight=bold]

pack .exit -padx 10 -pady 10 -fill x

if { !$simplewish} {
after 1 wm deiconify .
MainLoop
}
# EOF
