'\"
'\" Copyright (c) 1996 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) Hyperhelp.n
'/" 
.so man.macros
.HS hyperhelp iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
hyperhelp \- Create and manipulate a hyperhelp widget
.SH SYNOPSIS
\fBhyperhelp\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- shell <- hyperhelp
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5c 10c
\fBactiveBackground\fR	\fBbackground\fR	\fBborderWidth\fR
\fBcursor\fR	\fBexportSelection\fR	\fBforeground\fR
\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBinsertBackground\fR
\fBinsertBorderWidth	\fBinsertOffTime\fR	\fBinsertOnTime\fR
\fBinsertWidth\fR	\fBpadX\fR	\fBpadY\fR
\fBrelief\fR	\fBrepeatDelay\fR	\fBrepeatInterval\fR
\fBselectBackground\fR	\fBselectBorderWidth\fR	\fBselectForeground\fR
\fBsetGrid\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBhscrollmode\fR	\fBvscrollmode\fR	\fBtextbackground\fR	\fBfontname\fR
\fBfontsize\fR	\fBfixedfont\fR	\fBlink\fR	\fBlinkhighlight\fR
\fBwidth\fR	\fBheight\fR	\fBstate\fR	\fBwrap\fR
\fBunknownimage\fR
.fi
.LP
See the "scrolledhtml" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBmodality\fR	\fBtitle\fR 
.fi
.LP
See the "shell" manual entry for details on the above inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:   \fBtopics\fR
Class:  \fBTopics\fR
Command-Line Switch:    \fB-topics\fR
.fi
.IP
Specifies a list of help topics in the form {?\fItopic\fR? ... }. The 
document associated with each topic should be in the file 
\fBhelpdir\fR/\fItopic\fR.html.
.LP
.nf
Name:   \fBhelpdir\fR
Class:  \fBDirectory\fR
Command-Line Switch:    \fB-helpdir\fR
.fi
.IP
Specifies the directory where help files are located.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBhyperhelp\fR command creates a shell window with a pulldown menu
showing a list of topics. The topics are displayed by importing a HTML
formatted file named \fBhelpdir\fR/\fItopic\fR.html. For a list of 
supported HTML tags, see \fBscrolledhtml(n)\fR.

.SH "METHODS"
.PP
The \fBhyperhelp\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for dialog widgets:
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBchildsite\fR	\fBdeactivate\fR
.fi
.LP
See the "shell" manual entry for details on the above inherited methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBhyperhelp\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBhyperhelp\fR
command.
.TP
\fIpathName\fR \fBshowtopic\fR \fItopic\fR
Display html file \fBhelpdir\fR/\fItopic\fR.html. \fITopic\fR may
optionally be of the form \fItopicname\fR#\fIanchorname\fR. In
this form, either \fItopicname\fR or \fIanchorname\fR or both may be empty. If
\fItopicname\fR is empty, the current topic is assumed. If \fIanchorname\fR
is empty, the top of the document is assumed
.TP
\fIpathName\fR \fBfollowlink\fR \fIhref\fR
Display html file \fBhelpdir\fR/\fIhref\fR. \fIHref\fR may
be optionally be of the form \fIfilename\fR#\fIanchorname\fR. In
this form, either \fIfilename\fR or \fIanchorname\fR or both may be empty. If
\fIfilename\fR is empty, the current document is assumed. If \fIanchorname\fR
is empty, the top of the document is assumed.
.TP
\fIpathName\fR \fBforward\fR
Display html file one forward in history list, if applicable.
.TP
\fIpathName\fR \fBback\fR
Display html file one back in history list, if applicable.

.SH EXAMPLE
.DS
 hyperhelp .h -topics { Intro Help } -helpdir ~/help
 .h showtopic Intro
 
.DE
.SH AUTHOR
Kris Raney
.SH KEYWORDS
hyperhelp, html, help, shell, widget
