'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) selectiondialog.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS selectiondialog iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
selectiondialog \- Create and manipulate a selection dialog widget
.SH SYNOPSIS
\fBselectiondialog\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- Shell <- Dialogshell <- Dialog <- Selectiondialog
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBexportSelection\fR	\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR
\fBinsertBackground\fR	\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR
\fBinsertWidth\fR	\fBrelief\fR	\fBrepeatDelay\fR	\fBrepeatInterval\fR
\fBselectBackground\fR	\fBselectBorderWidth\fR	\fBselectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBtextBackground\fR	\fBtextFont\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR	\fBlabelMargin\fR
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget class manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBhscrollMode\fR	\fBitems\fR	\fBsbWidth\fR	\fBscrollMargin\fR
\fBtextBackground\fR	\fBtextFont\fR	\fBvscrollMode\fR
.fi
.LP
See the "scrolledlistbox" widget class manual entry for details on the above
associated options.
\fBchildsitepos\fR	\fBitemsCommand\fR	\fBitemsLabel\fR	\fBitemsLabelPos\fR
\fBitemsOn\fR	\fBmargin\fR	\fBselectionCommand\fR	\fBselectionLabel\fR
\fBselectionLabelPos\fR	\fBselectionOn\fR
.fi
.LP
See the "selectionbox" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbuttonBoxPadX\fR	\fBbuttonBoxPadY\fR 	\fBbuttonBoxPos\fR	\fBpadX\fR
\fBpadY\fR	\fBseparator\fR	\fBthickness\fR
.fi
.LP
See the "dialogshell" widget  manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBmodality\fR	\fBtitle\fR 
.fi
.LP
See the "shell" widget  manual entry for details on the above
inherited options.
.LP
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the selection dialog.  The value may be specified in 
any of the forms acceptable to Tk_GetPixels.  The default is 350 pixels.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the selection dialog.  The value may be specified in 
any of the forms acceptable to Tk_GetPixels.  The default is 300 pixels.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBselectiondialog\fR command creates a selection box similar to 
the OSF/Motif standard selection
dialog composite widget.  The selectiondialog is derived from the 
Dialog class and is composed of a selectionbox with commands 
to manipulate the dialog buttons.

.SH "METHODS"
.PP
The \fBselectiondialog\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for selectiondialog widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBchildsite\fR	\fBclear\fR	\fBget\fR	\fBinsert\fR
\fBselectitem\fR
.fi
.LP
See the "selectionbox" widget manual entry for details on the above
associated methods.
.LP
.nf
.ta 4c 8c 12c
\fBcurselection\fR	\fBdelete\fR	\fBindex\fR	\fBnearest\fR
\fBscan\fR	\fBselection\fR	\fBsize\fR
.fi
.LP
See the "listbox" widget manual entry for details on the above
associated methods.
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBbuttonconfigure\fR	\fBdefault\fR	\fBhide\fR
\fBinvoke\fR	\fBshow\fR	
.fi
.LP
See the "buttonbox" widget manual entry for details on the above
inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBdeactivate\fR
.fi
.LP
See the "shell" widget manual entry for details on the above
inherited methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBselectiondialog\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBselectiondialog\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBsb\fR
Class:	\fBSelectionbox\fR
.fi
.IP
The sb component is the selection box for the selection dialog.  See 
the "selectionbox" widget manual entry for details on the sb component item.
.fi

.SH EXAMPLE
.DS
 option add *textBackground GhostWhite

 selectiondialog .sd 
 .sd activate
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
selectiondialog, selectionbox, dialog, dialogshell, shell, widget
