source stooop.tcl

### check various virtual procedures with variable number of arguments configurations in a 3 level deep class hierarchy

# expected output:
## c::f 1 x {y z}
## c::g 1 x {y z}
## b::h 1 x {y z}
## b::i 1 x {y z}
## c::k 1 x {y z}
## c::l 1 x {y z}

proc a::a {this} {}
proc a::~a {this} {}
virtual proc a::f {this p args} {}
virtual proc a::g {this p args}
virtual proc a::h {this p args} {
    puts "a::h $this $p $args"
}
virtual proc a::i {this p args} {
    puts "a::i $this $p $args"
}
virtual proc a::k {this p args}
virtual proc a::l {this p args} {
    puts "a::l $this $p $args"
}

proc b::b {this} a {} {}
proc b::~b {this} {}
virtual proc b::f {this p args} {
    puts "b::f $this $p $args"
}
virtual proc b::g {this p args}
virtual proc b::h {this p args} {
    puts "b::h $this $p $args"
}
proc b::i {this p args} {
    puts "b::i $this $p $args"
}
virtual proc b::k {this p args} {
    puts "b::k $this $p $args"
}
virtual proc b::l {this p args}

proc c::c {this} b {} {}
proc c::~c {this} {}
proc c::f {this p args} {
    puts "c::f $this $p $args"
}
proc c::g {this p args} {
    puts "c::g $this $p $args"
}
proc c::i {this p args} {
    puts "c::i $this $p $args"
}
proc c::k {this p args} {
    puts "c::k $this $p $args"
}
proc c::l {this p args} {
    puts "c::l $this $p $args"
}

set o [new c]
a::f $o x {y z}
a::g $o x {y z}
a::h $o x {y z}
a::i $o x {y z}
a::k $o x {y z}
a::l $o x {y z}
