source stooop.tcl

### check various virtual procedures configurations in a 3 level deep class hierarchy

# expected output:
## c::f 1 x y z
## c::g 1 x y z
## b::h 1 x y z
## b::i 1 x y z
## c::k 1 x y z
## c::l 1 x y z

proc a::a {this} {}
proc a::~a {this} {}
virtual proc a::f {this p q} {}
virtual proc a::g {this p q}
virtual proc a::h {this p q} {
    puts "a::h $this $p $q"
}
virtual proc a::i {this p q} {
    puts "a::i $this $p $q"
}
virtual proc a::k {this p q}
virtual proc a::l {this p q} {
    puts "a::l $this $p $q"
}

proc b::b {this} a {} {}
proc b::~b {this} {}
virtual proc b::f {this p q} {
    puts "b::f $this $p $q"
}
virtual proc b::g {this p q}
virtual proc b::h {this p q} {
    puts "b::h $this $p $q"
}
proc b::i {this p q} {
    puts "b::i $this $p $q"
}
virtual proc b::k {this p q} {
    puts "b::k $this $p $q"
}
virtual proc b::l {this p q}

proc c::c {this} b {} {}
proc c::~c {this} {}
proc c::f {this p q} {
    puts "c::f $this $p $q"
}
proc c::g {this p q} {
    puts "c::g $this $p $q"
}
proc c::i {this p q} {
    puts "c::i $this $p $q"
}
proc c::k {this p q} {
    puts "c::k $this $p $q"
}
proc c::l {this p q} {
    puts "c::l $this $p $q"
}

set o [new c]
a::f $o x {y z}
a::g $o x {y z}
a::h $o x {y z}
a::i $o x {y z}
a::k $o x {y z}
a::l $o x {y z}
