set rcsId {$Id: class.tcl,v 1.9 1995/11/19 10:27:59 jfontain Exp $}

proc class::class {this name bases} {
    set class($this,name) $name
    set class($this,bases) $bases
    set class($this,procedures) {}
    set class($this,derived) {}
    set class($this,data) {}
}

proc class::~class {this} {}

proc class::addProcedure {this name {type regular}} {
    # type can be regular, virtual, pure or static

    if {[lsearch -exact $class($this,procedures) $name]>=0} {
        return
    }
    lappend class($this,procedures) $name
    set class($this,type,$name) $type
}

proc class::addDerived {this name} {
    if {[lsearch -exact $class($this,derived) $name]<0} {
        lappend class($this,derived) $name
    }
}

proc class::addData {this name {static 0}} {
    if {[lsearch -exact $class($this,data) $name]>=0} {
        return
    }
    lappend class($this,data) $name
    if {$static} {
        set class($this,static,$name) {}
    }
}
