#!/util/tcl/bin/tclsh

# read lines from standard input until
# end of file encountered
while {[gets stdin line] >= 0} {
   if [info exists Freq($line)] {
      # the item is already in the array,
      # so just increment its count
      incr Freq($line)
   } else {
      # the item is not in the array yet,
      # so initialize its count
      set Freq($line) 1
   }
}

# iterate through every item and print it
# and its frequency count
foreach item [array names Freq] {
   puts stdout "$item $Freq($item)"
}
