--------------------------------------------------------------------
--
-- tash.adb --
--
-- Copyright (c) 1995 Terry J. Westley
--
-- See the file "license.terms" for information on usage and redistribution
-- of this file, and for a DISCLAIMER OF ALL WARRANTIES.
--
--
--------------------------------------------------------------------

with Ada.Command_Line;
with C_Aux;
with Interfaces.C.Strings;
with Tcl;
with TashApp;

procedure tash is -- Tcl Ada SHell

   package C renames Interfaces.C;

   function "+" (Left, Right : in C.Int) return C.Int renames C."+";

   -- Argc and Argv include the command name
   Argc : C.Int := C.Int (Ada.Command_Line.Argument_Count) + 1;
   Argv : C_Aux.Arg_Vector(1..Argc);

begin -- tash

   -- Get command-line arguments and put them into C-style "argv,"
   -- as required by Tcl.Main.
   C_Aux.Get_Argv (Argv);

   -- Start Tcl
   Tcl.Main (Argc, Argv(Argv'first)'unchecked_access, TashApp.Init'access);

end tash;
