--------------------------------------------------------------------
--
-- tk.ads --
--
--	This is a prototype of an Ada 95 interface to Tk version 4.1a2.
--	It is not intended to provide an interface to Tk capabilities, but
--	only to allow initializing Tk so that Tcl/Tk scripts can be written
--	and executed.
--
-- Copyright (c) 1987-1994 The Regents of the University of California.
-- Copyright (c) 1994      The Australian National University.
-- Copyright (c) 1994-1995 Sun Microsystems, Inc.
-- Copyright (c) 1996      Terry J. Westley
--
-- See the file "license.terms" for information on usage and redistribution
-- of this file, and for a DISCLAIMER OF ALL WARRANTIES.
--
--------------------------------------------------------------------

with C_Aux;
with Interfaces.C.Strings;
with Tcl;

package Tk is

   Version       : constant String := "4.1";
   Major_Version : constant String := "4";
   Minor_Version : constant String := "1";
   Ada_Version	 : constant String := "1.0a2";

   package C renames Interfaces.C;

   function Init (
      interp          : in Tcl.Interp_Ptr) return C.Int;
   pragma Import (C, Init, "Tk_Init");

   procedure Main (
      argc            : in C.Int;
      argv            : in C_Aux.Chars_Ptr_Ptr;
      appInitProc     : in Tcl.AppInitProc_Ptr);
   pragma Import (C, Main, "Tk_Main");

end Tk;
