--------------------------------------------------------------------
--
-- twashapp.adb --
--
-- Copyright (c) 1995 Terry J. Westley
--
-- See the file "license.terms" for information on usage and redistribution
-- of this file, and for a DISCLAIMER OF ALL WARRANTIES.
--
--
--------------------------------------------------------------------

with Tk;

package body TWashApp is

   function "=" (Left, Right : in C.Int) return Boolean renames C."=";

   function Init (
      Interp : in Tcl.Interp_Ptr) return C.Int is

   begin -- Init

      if Tcl.Init(interp) = Tcl.ERROR then
	 return Tcl.ERROR;
      end if;

      if Tk.Init(interp) = Tcl.ERROR then
	 return Tcl.ERROR;
      end if;

      -- Call the init procedures for included packages.  Each call should
      -- look like this:
      -- 
      -- if Mod.Init(interp) = Tcl.ERROR then
      --    return Tcl.ERROR;
      -- end if;
      --
      -- where "Mod" is the name of the module.

      -- Call CreateCommand for application-specific commands, if
      -- they weren't already created by the init procedures called above.

      -- Specify a user-specific startup file to invoke if the application
      -- is run interactively.  Typically the startup file is "~/.apprc"
      -- where "app" is the name of the application.  If this line is deleted
      -- then no user-specific startup file will be run under any conditions.

      Tcl.SetVar(interp, "tcl_rcFileName", "~/.twashrc", Tcl.GLOBAL_ONLY);
      return Tcl.OK;

   end Init;

end TWashApp;
