set case_number 0

proc test_case {command} {
   global case_number
   incr case_number
   catch {uplevel $command} result
   puts stdout [format "Case %2d: %s: %s" $case_number $command $result]
}

#| check argc and argv
test_case {set argc}
test_case {set argv}

#| test eq command
if {[info commands eq] == "eq"} {
   test_case {eq abc def}
   test_case {eq 1 1}
   set w1 .dlg
   set w2 .dlg.ok
   test_case {eq $w1.ok $w2}
}

#| test concat command
test_case {concat}
test_case {concat abc {def}}
test_case {concat {a b c} d {e f} g h}

#| test list command
test_case {list}
test_case {list abc {x y} \}}

#| test object-oriented counter
test_case {counter}
test_case {counter}

ctr0 next; ctr0 next; test_case {ctr0 get}

test_case {ctr1 get}

test_case {ctr0 clear}

rename ctr0 {}; test_case {ctr0 get}

test_case {sum 2 3}
test_case {sum 011 0x14}
test_case {sum 8#011# 16#14#}
test_case {sum 2#011# 2#1_000#}
test_case {sum 3 6z}
test_case {sum a3 6}

#| simple expr command
set x 1
test_case {simple_expr $x+1}
test_case {simple_expr $x + 1}
test_case {simple_expr}
