#!/usr/local/bin/wish -f

# $Header: /net/src/prog-tools/btcl.alpha/tclTCP2.2/demos/RCS/colortab.tcl,v 1.2 1996/01/26 15:29:46 vanandel Exp $
# $Source: /net/src/prog-tools/btcl.alpha/tclTCP2.2/demos/RCS/colortab.tcl,v $
# $Log: colortab.tcl,v $
# Revision 1.2  1996/01/26  15:29:46  vanandel
# *** empty log message ***
#
# Revision 1.1  1996/01/26  01:45:55  vanandel
# Initial revision
#
# Revision 1.2  1992/05/05  18:34:03  kennykb
# Changed the `listbox' command to work under either Tk 2.0 or Tk 1.4.
# (the -scroll option changes to -yscroll in 2.0)
#
# Revision 1.1  1992/02/14  20:02:38  kennykb
# Initial revision
#

#  Copyright (C) 1992 General Electric. All rights reserved.

#  Permission to use, copy, modify, and distribute this
#  software and its documentation for any purpose and without
#  fee is hereby granted, provided that the above copyright
#  notice appear in all copies and that both that copyright
#  notice and this permission notice appear in supporting
#  documentation, and that the name of General Electric not be used in
#  advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#  General Electric makes no representations about the suitability of
#  this software for any purpose.  It is provided "as is"
#  without express or implied warranty.

#  This work was supported by the DARPA Initiative in Concurrent
#  Engineering (DICE) through DARPA Contract MDA972-88-C-0047.

# This is a client to the master color server.  It displays a list-box view
# of the current color.

source [info library]/init.tcl

# Read the color table

set f [open rgb.txt]
while {[gets $f line] >= 0} {
	set fields [split $line \t]
	set color([lindex $fields 1]) [lindex $fields 0]
}
close $f

# Connect to the master server

set c [tcp connect localhost 2324]

# Build the display

label .text -text "A sample palette of colors"

frame .body
scrollbar .body.scroll -relief sunken -command ".body.list yview"
listbox .body.list -width 30 -height 20 -font fixed -relief sunken \
		-yscroll ".body.scroll set"
pack append .body .body.scroll {right expand filly frame w} \
		.body.list {left expand filly frame e}

foreach i [lsort [array names color]] {
	.body.list insert end $i
}

message .prompt \
	-text "Double-click the left button on a color to try it out." \
	-aspect 400

button .quit -text "Quit" -command "destroy ."

pack append . .text {top expand fillx} \
	.body {top expand fillx} \
	.prompt {top expand fillx} \
	.quit {top expand fillx}

bind .body.list <Double-1> {docolor [selection get]}

proc docolor {colornames} {
	global color
	global c
	set colorname [lindex $colornames 0]
	set colorval $color($colorname)
	$c send set red [lindex $colorval 0]
	$c send set green [lindex $colorval 1]
	$c send set blue [lindex $colorval 2]
}
