#!/usr/local/bin/wish -f

# $Header: /net/src/prog-tools/btcl.alpha/tclTCP2.2/demos/RCS/master.tcl,v 1.1 1996/01/26 15:29:46 vanandel Exp $
# $Source: /net/src/prog-tools/btcl.alpha/tclTCP2.2/demos/RCS/master.tcl,v $
# $Log: master.tcl,v $
# Revision 1.1  1996/01/26  15:29:46  vanandel
# Initial revision
#
# Revision 1.2  1992/05/05  18:32:48  kennykb
# Removed logic to print tty messages when setting color values.  The change
# speeds up the setting and rebroadcast substantially.
#
# Revision 1.1  1992/02/14  20:03:08  kennykb
# Initial revision
#

#  Copyright (C) 1992 General Electric. All rights reserved.

#  Permission to use, copy, modify, and distribute this
#  software and its documentation for any purpose and without
#  fee is hereby granted, provided that the above copyright
#  notice appear in all copies and that both that copyright
#  notice and this permission notice appear in supporting
#  documentation, and that the name of General Electric not be used in
#  advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#  General Electric makes no representations about the suitability of
#  this software for any purpose.  It is provided "as is"
#  without express or implied warranty.

#  This work was supported by the DARPA Initiative in Concurrent
#  Engineering (DICE) through DARPA Contract MDA972-88-C-0047.

# Here is the `master model' for the color swatch

set red 200
set green 200
set blue 200

# The following procedure is used to generate symbols, e.g., transient
# procedure names

set gensym.counter 1
proc gensym {{base gensym}} {
	global gensym.counter
	return $base[incr gensym.counter]
}

# When anyone updates a color, the following runs.

proc updcolor {color subscript op} {
#	upvar 1 $color colour
#	puts stdout "$color level set to $colour"
}

trace variable red w updcolor
trace variable green w updcolor
trace variable blue w updcolor

set s [tcp server -port 2324 -command {tcp eval}]
$s start
puts stdout "Server listening at port [$s configure -port]"

proc shutdown {} {
	foreach svr [tcp servers] {
		$svr stop
	}
	destroy .
}

button .quit -text "Quit" -command shutdown
pack append . .quit {top expand fill}
# wm iconify .
tcp mainloop
