#!/usr/local/bin/wish -f

# $Header: /net/src/prog-tools/btcl.alpha/tclTCP2.2/demos/RCS/swatch.tcl,v 1.2 1996/01/26 15:29:46 vanandel Exp $
# $Source: /net/src/prog-tools/btcl.alpha/tclTCP2.2/demos/RCS/swatch.tcl,v $
# $Log: swatch.tcl,v $
# Revision 1.2  1996/01/26  15:29:46  vanandel
# *** empty log message ***
#
# Revision 1.1  1996/01/25  23:51:04  vanandel
# Initial revision
#
# Revision 1.1  1992/02/14  20:03:21  kennykb
# Initial revision
#

#  Copyright (C) 1992 General Electric. All rights reserved.

#  Permission to use, copy, modify, and distribute this
#  software and its documentation for any purpose and without
#  fee is hereby granted, provided that the above copyright
#  notice appear in all copies and that both that copyright
#  notice and this permission notice appear in supporting
#  documentation, and that the name of General Electric not be used in
#  advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#  General Electric makes no representations about the suitability of
#  this software for any purpose.  It is provided "as is"
#  without express or implied warranty.

#  This work was supported by the DARPA Initiative in Concurrent
#  Engineering (DICE) through DARPA Contract MDA972-88-C-0047.

# This is a client to the master color server.  It displays a view of the
# current color.

# Start a server so we can get updates

set s [tcp server]
$s start
set p [$s config -port]

# Connect to the master server

#puts stderr "about to connect"
set c [tcp connect localhost 2324]
#puts stderr "connect complete"

# Build the display

message .text -text "The frame to the right of this message shows the color being maintained by the ``master'' application."

frame .swatch
frame .swatch.vstrut -width 1 -height 100
frame .swatch.hstrut -width 100 -height 1
pack append .swatch .swatch.vstrut {left} .swatch.hstrut {top}

button .quit -text "Quit" -command "destroy ."

pack append . .text {left expand fill} \
	.swatch {left expand} \
	.quit {left expand filly}

# Define a local procedure to receive a new set of colors and update the
# swatch

proc newcolors {red green blue} {
	.swatch config -background \
		[format #%02x%02x%02x $red $green $blue]
}

# Get a name for this application in the master server

#puts stderr "about to send gensym"
set myname [$c send gensym swatch]
#puts stderr "send complete"

# Define a procedure in the master server to update our colors

#puts stderr "about to send update proc"
$c send [format {
    proc %s.update args {
	global red
	global green
	global blue
	global %s.connection
	${%s.connection} send newcolors $red $green $blue
    }} $myname \
	$myname\
	$myname]
#puts stderr "send update proc complete"

# Remove traces when we exit

bind .swatch <Destroy> {
	$c send trace vdelete red w $myname.update
	$c send trace vdelete green w $myname.update
	$c send trace vdelete blue w $myname.update
	$c send rename $myname.update {}
	set action "\$\{$myname.connection\} close"
	$c send $action
}

# Make the master server open a connection to us

set action [format {    
# puts stderr "Got msg from swatch"
    	    	after 1000 {
		set %s.connection [tcp connect localhost %d]
#   	    	puts stderr  "got connection"
		%s.update
#    	    	puts stderr  "update complete"
		${%s.connection} send after 10000 startTracing}
	} $myname $p \
	  $myname \
	  $myname \
	  $myname]
#puts stderr "sending action $action"
$c send $action
#puts stderr "send action completed"

# Set up the traces in the master server

proc startTracing {} {
	global c
	global myname
	$c send trace variable red w $myname.update
	$c send trace variable green w $myname.update
	$c send trace variable blue w $myname.update
}


