/*-
 * Copyright (c) 1993, 1994, 1995, 1996 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <assert.h>
#include <string.h>

#include "MChanPrf.h"

MetaChannelPrefixEvent::MetaChannelPrefixEvent() : data(0), length(0L)
{
}

MetaChannelPrefixEvent::MetaChannelPrefixEvent(unsigned long t,
    const unsigned char *dat, long len) : MetaEvent(t), length(len)
{

	data = new unsigned char[len];
	assert(data != 0);
//	memmove(data, dat, len);
	memcpy(data, dat, len);
}

MetaChannelPrefixEvent::MetaChannelPrefixEvent(const MetaChannelPrefixEvent &e) :
    MetaEvent(e), length(e.length)
{

	data = new unsigned char[e.length];
	assert(data != 0);
//	memmove(data, e.data, e.length);
	memcpy(data, e.data, e.length);
}

MetaChannelPrefixEvent::~MetaChannelPrefixEvent()
{

	delete data;
}

void
MetaChannelPrefixEvent::SetData(const unsigned char *dat, long len)
{

	if (data != 0)
		delete data;
	data = new unsigned char[len];
	assert(data != 0);
//	memmove(data, dat, len);
	memcpy(data, dat, len);
}

MetaChannelPrefixEvent &
MetaChannelPrefixEvent::operator=(const MetaChannelPrefixEvent &e)
{

	(MetaEvent)*this = (MetaEvent)e;
	if (data != 0)
		delete data;
	data = new unsigned char[e.length];
	length = e.length;
	assert(data != 0);
//	memmove(data, e.data, e.length);
	memcpy(data, e.data, e.length);
	return (*this);
}

char *
MetaChannelPrefixEvent::GetEventStr(void) const
{
	ostrstream buf;
	char *tbuf;
	long i;

	tbuf = MetaEvent::GetEventStr();
	buf << tbuf << " Data:";
	buf.setf(ios::showbase | ios::internal);
	for (i = 0; i < length; i++)
		buf << " " << hex << setw(4) << setfill('0') << (int)data[i];
	buf << ends;
	delete tbuf;
	return (buf.str());
}

const char *
MetaChannelPrefixEvent::SMFRead(SMFTrack &t)
{
	const unsigned char *ptr;

	if (data != 0)
		delete data;
	if ((length = t.GetVarValue()) == -1)
		return ("Incomplete MetaChannelPrefixEvent - bad length");
	data = new unsigned char[length];
	if (data == 0)
		return ("Out of memory");
	if ((ptr = t.GetData(length)) == 0)
		return ("Incomplete MetaChannelPrefixEvent - bad data");
	memcpy(data, ptr, length);
	return (0);
}

const char *
MetaChannelPrefixEvent::SMFWrite(SMFTrack &t) const
{

	if (!t.PutFixValue(length))
		return ("Out of memory");
	if (!t.PutData(data, length))
		return ("Out of memory");
	return (0);
}

int
MetaChannelPrefixEvent::Equal(const Event *e) const
{
	long i;
	MetaChannelPrefixEvent *eptr = (MetaChannelPrefixEvent *)e;

	if (!MetaEvent::Equal(e))
		return (0);
	if (length != eptr->length)
		return (0);
	for (i = 0; i < length; i++)
		if (data[i] != eptr->data[i])
			return (0);
	return (1);
}

ostream &
operator<<(ostream &os, const MetaChannelPrefixEvent &e)
{
	char *str;

	os << (str = e.GetEventStr());
	delete str;
	return (os);
}
