/*-
 * Copyright (c) 1995, 1996 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef MIDI_GUS_H
#define MIDI_GUS_H


/*
 * midi port offsets
 */
#define GUS_IRQ_CONTROL			0x0B
#define GUS_MIDI_CONTROL		0x100
#define GUS_MIDI_STATUS			0x100
#define GUS_MIDI_DATA			0x101

/*
 * port offsets from GUS DOS code for use in probing etc.
 */
#define GF1_REG_SELECT			0x103
#define GF1_DATA_LOW			0x104
#define GF1_DATA_HI			0x105
#define GF1_DRAM			0x107

#define SET_DRAM_LOW			0x43
#define SET_DRAM_HIGH			0x44
#define GF1_MASTER_RESET		0x01
#define MASTER_RESET			0x4c

/*
 * midi data transfer status bits
 */
#define MIDI_RDY_RCV			(1 << 1)
#define MIDI_DATA_AVL			(1 << 0)

/*
 * Our version of the midi_iface structure.
 */
struct midi_iface_gus {
	struct	midi_iface iface;
	int	addr;
};

#define MIDI_TRIES			200000

/*
 * standard mpu401 interface functions - for use by other mpu401 varients.
 */
const char *gus_name(struct midi_iface *mif);
void gus_size(struct midi_iface *mif, void *size);
void gus_gen_intr(struct midi_iface *mif);
int gus_big_reset(struct midi_iface *mif);
int gus_open(struct midi_iface *mif);
void gus_close(struct midi_iface *mif);
int gus_intr(struct midi_iface *mif);
int gus_data_avail(struct midi_iface *mif);
void gus_write(struct midi_iface *mif, struct event *event);
u_char gus_read(struct midi_iface *mif);
int gus_feature(struct midi_iface *iface, struct midi_feature *feature);
void gus_free(struct midi_iface *mif);

int gus_wait_rdy_rcv(struct midi_iface_gus *iface);
void gus_reset(struct midi_iface_gus *iface);

#endif
