#!/usr/local/bin/tclsap
#############################################################
# Item_Info_Www.tcl
#
# This script executes an ABAP that returns the material number 
# length and the setting of the leading zeros flag in the SAP
# system. 
#
# Garth Kennedy  30 August 1995
#
# Copyright Motorola Inc 1995
#
#
#  Part of tclsap - version 0.2  released 14 December 1995
#
# AUTHOR:
#      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
#      Land Mobile Products  Motorola Inc. 
#      Schaumburg, Ill.
#
# COPYRIGHT NOTICE:
#      Copyright 1995   Motorola Inc.;
#      Permission to use, copy modify and distribute without charge
#      this software, documentation etc. is granted, provided that
#      this comment and the author's name is retained. Neither the
#      author or Motorola assume any responsibility for problems
#     resulting from the use of this software.
#
############################################################
#
set envvars {SERVER_SOFTWARE SERVER_NAME GATEWAY_INTERFACE SERVER_PROTOCOL SERVER_PORT REQUEST_METHOD PATH_INFO PATH_TRANSLATED SCRIPT_NAME QUERY_STRING REMOTE_HOST REMOTE_ADDR REMOTE_USER AUTH_TYPE CONTENT_TYPE CONTENT_LENGTH HTTP_ACCEPT HTTP_REFERER HTTP_USER_AGENT}

#
# UnCgi Translation hack, in Tcl, v1.4 5/1995 by dl@hplyot.obspm.fr
#
proc uncgi {buf} {
# looks like ncsa httpd transforms ' -> \'
regsub -all {\\'} $buf {'} buf ;
regsub -all {\\} $buf {\\\\} buf ;
regsub -all { }  $buf {\ } buf ;
regsub -all {\+} $buf {\ } buf ;
regsub -all {\$} $buf {\$} buf ;
regsub -all \n   $buf {\n} buf ;
regsub -all {;}  $buf {\;} buf ;
regsub -all {\[} $buf {\[} buf ;
regsub -all \" $buf \\\" buf ;
# the next one can probably be skipped as the first char is prolly not
# an \{, but, hey who knows... lets be safe...
regsub  ^\{ $buf \\\{ buf ;
# I think everything has been escaped, now the real work :
regsub -all -nocase {%([a-fA-F0-9][a-fA-F0-9])} $buf {[format %c 0x\1]} buf
# And now lets replace all those escaped back, along with excuting of
# the format :
eval return \"$buf\"
# now everything is in buf, but translated, nice trick no ?
}

# returns in the 'cgi' array all the parameters sent to the script
# through 'message' (each array cell is a list (ie if only one value
# is expected through 'test' variable, use [lindex $cgi(test) 0] to get it)).
proc parse_cgi_message {message} {
global cgi;
set cgi() "";
foreach pair [split $message &] {
  set plst [split $pair =];
  set name [uncgi [lindex $plst 0]];
  set val  [uncgi [lindex $plst 1]];
  lappend cgi($name) $val;
}
}


puts "Content-type: text/html\n"
puts "<HTML>"
puts "<HEAD>"
puts "<TITLE>Material Number Settings in SAP</TITLE>"
puts "</HEAD>"


puts "<BODY>"
puts "<H1>Material Number Settings in SAP</H1>"
puts "<P>"
puts "<HR>"


if {[string compare $env(REQUEST_METHOD) "POST"]==0} {
set message [read stdin $env(CONTENT_LENGTH)];
} else {
set message $env(QUERY_STRING)
}
parse_cgi_message $message;


set sid [lindex $cgi(sid) 0]
set client [lindex $cgi(client) 0]
set user [lindex $cgi(user) 0]
set pword  [lindex $cgi(pword) 0]
set trace "0"
set sap_item [lindex $cgi(sap_item) 0]
set sid  [string trimright $sid]
set client  [string trimright $client]
set user  [string trimright $user]
set pword [string trimright $pword]
set sap_item [string trimright $sap_item]
set sid [string toupper $sid]
set client [string toupper $client]
set user [string toupper $user]
set pword  [string toupper $pword]
set sap_item [string toupper $sap_item]

 
if [catch {Sap_Open $sid $client $user $pword $trace } result] { 
    set sap_conn "No" 
} else {  
    set sap_conn "Yes" 
} 
 
if [catch {Sap_RfcPing } result] { 
    set xsap_login "No" 
} else { 
    set xsap_login "Yes" 
} 


# Was the login Successful ?
if { [string compare $sap_conn "Yes"] == 0 } {
    if { [string compare $xsap_login "Yes"] == 0 } {
        set items " "
        set sap_length " "
        set sap_leadz " "
        
        set items [Sap_Callrx2 Z_FIAM_ITEM "36$sap_item" ]

        set sap_length    [string range $items  0  4]
        set sap_leadz    [string index $items  5 ]

        puts "<P>"
        puts "On the <B>SAP</B> System <B>$sid</B><br>"
        puts "for the entered Item Number of <B>$sap_item</B><P>"
        puts "the length for Material Numbers is <B>$sap_length characters</B><br>"
        puts "and the leading zero flag setting is <B>$sap_leadz</B>"
        puts "<P>"
    }  else {       
        puts "<P>"
        puts "The connect to SAP was successful, but the login was not.<P>"
        puts "Did you use the right User ID, Password and Client ?"
    }
} else {
    puts "<P>"
    puts "The connect to SAP was NOT successful.<P>"
    puts "Did you use the right System ID ?"
    puts "<P>"
}
puts "<P>"
puts "<HR>"
puts "<P>"
puts "This report was brought you courtesy of tclsap"
puts "<HR>"
puts "</BODY>"
puts "</HTML>"

Sap_Close

exit


