/***********************************************************************
 * SAP_Header.h
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <saprfc.h>
#include <time.h>
#include <tcl.h>

#ifndef SAPTCL_H
#define SAPTCL_H

#ifdef MAIN
RFC_HANDLE              handle;
int sap_trace;
#else
extern RFC_HANDLE       handle;
extern int sap_trace;
#endif

/* internal function declarations */
int sap_check_error(char **exception_ptr, char *e_status, RFC_RC rfc_rc);
static void sap_rfc_error(char * operation);

int sap_err_split (char *err_str);
int sap_clear_err();
int sap_err_print_str(char *err_str);
static void rfc_error (char * operation);

 
/******************************************************************
 * sap_rfc_error
 * Description:	dump status after a failure of a remote 
 *              function call - this is a dummy process
 ******************************************************************/
static void 
sap_rfc_error( char * operation )
{
    time_t  tt;
    struct tm  *ts;
     
    RFC_ERROR_INFO error_info;
 
    memset( &error_info, 0, sizeof( error_info ) );
    RfcLastError( &error_info );

    RfcClose( RFC_HANDLE_NULL );
   
   
   /* exit( 1 ); */
}   /* end of sap_rfc_error()  */

#endif /* SAPTCL_H not defined */
