/***********************************************************************
 * Sap_RFCPing.c
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/
#include "Sap_Header.h"

/******************************************************************************
 * sap_RfcPingCmd()
 *
 * Call the ABAP function RFCPING and verify no errors
 * Use this to check connectivity after RfcOpen(), since an RfcOpen
 * positive return does not indicate successful login.
 *
 * Garth Kennedy    15 Aug 1995
 ******************************************************************************/
sap_RfcPingCmd( ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
   RFC_PARAMETER      exporting[32];
   RFC_PARAMETER      importing[32];
   RFC_TABLE          tables[32];
   static RFC_RC      rfc_rc;
   char 	      *exception_ptr;
   char               e_status[300];       /* error and status return */
   int     ret_val;
       


        /* argument passed to the remote R/3 ABAP function */
    exporting[0].name = NULL;

        /* result that we expect from the remote R.3 ABAP function */
    importing[0].name = NULL;

       /* not used */
    tables[0].name    = NULL;

             
     /* do the call */
    rfc_rc = RfcCallReceive( handle, "RFCPING", exporting,
                             importing, tables, &exception_ptr);
            
                 /* get the response */
                 
    ret_val = sap_check_error(&exception_ptr, e_status, rfc_rc);

    sprintf(interp->result, "%s", e_status);
    
    if (rfc_rc == 0)
        return TCL_OK;
    else
        return TCL_ERROR;
        
}    /* end sap_RfcPingCmd()   */



